/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.content_packs.forge;

import com.possible_triangle.content_packs.CommonClass;
import com.possible_triangle.content_packs.forge.ForgeRegistryCache;
import com.possible_triangle.content_packs.forge.compat.CompatMods;
import com.possible_triangle.content_packs.forge.compat.VSlabCompatCompat;
import com.possible_triangle.content_packs.forge.compat.botania.BotaniaCompat;
import com.possible_triangle.content_packs.forge.compat.create.CreateCompat;
import com.possible_triangle.content_packs.platform.RegistryEvent;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="content_packs")
public class ForgeEntrypoint {
    private final ForgeRegistryCache cache = new ForgeRegistryCache();

    private RegistryEvent createRegisterEvent(final RegisterEvent event) {
        return new RegistryEvent(){

            @Override
            public <T, R extends T> Supplier<R> register(ResourceKey<Registry<T>> registry, ResourceLocation id, Supplier<R> factory) {
                if (event.getRegistryKey().equals(registry)) {
                    Object value = factory.get();
                    event.register(registry, id, () -> value);
                    return () -> value;
                }
                return () -> {
                    throw new IllegalStateException();
                };
            }

            @Override
            public void addToTab(ResourceKey<CreativeModeTab> tab, Supplier<ItemStack> supplier) {
                ForgeEntrypoint.this.cache.addToTab(tab, supplier);
            }
        };
    }

    public ForgeEntrypoint() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        CompatMods.ifLoaded(CompatMods.CREATE, () -> CreateCompat.init(modBus));
        CommonClass.load();
        modBus.addListener(event -> {
            RegistryEvent wrapped = this.createRegisterEvent((RegisterEvent)event);
            CommonClass.registerTypes(wrapped);
            CompatMods.ifLoaded(CompatMods.CREATE, () -> CreateCompat.register(wrapped));
            CompatMods.ifLoaded(CompatMods.BOTANIA, () -> BotaniaCompat.register(wrapped));
            CompatMods.ifLoaded(CompatMods.V_SLAB, () -> VSlabCompatCompat.register(wrapped));
        });
        modBus.addListener(EventPriority.LOWEST, event -> this.cache.register((RegisterEvent)event));
        modBus.addListener(this.cache::buildTabs);
    }
}

