/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.content_packs.loader;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Unit;

public class ContentLoader {
    private static final CompletableFuture<Unit> INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private static final PackType TYPE = PackType.valueOf((String)"CONTENT");
    private final ReloadableResourceManager manager = new ReloadableResourceManager(TYPE);
    private final Executor executor;
    private final PackRepository packRepository;

    private static Stream<RepositorySource> createDefaultSources(File directory) {
        return Stream.of(new FolderRepositorySource(directory.toPath(), PackType.SERVER_DATA, PackSource.f_10527_));
    }

    public ContentLoader(Executor executor, File directory) {
        this.executor = executor;
        this.packRepository = new PackRepository((RepositorySource[])ContentLoader.createDefaultSources(directory).toArray(RepositorySource[]::new));
    }

    public void register(PreparableReloadListener listener) {
        this.manager.m_7217_(listener);
    }

    private List<PackResources> findPacks() {
        this.packRepository.m_10506_();
        Collection available = this.packRepository.m_10514_();
        this.packRepository.m_10509_(available);
        return this.packRepository.m_10525_();
    }

    public ReloadInstance load() {
        return this.manager.m_142463_(this.executor, this.executor, INITIAL_TASK, this.findPacks());
    }
}

