/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.content_packs.loader.listener;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.possible_triangle.content_packs.Constants;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class CodecDrivenReloadListener<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private final RegistryAccess registryAccess;

    protected CodecDrivenReloadListener(String path, RegistryAccess registryAccess) {
        super(GSON, path);
        this.registryAccess = registryAccess;
    }

    protected abstract Codec<T> codec();

    protected final void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager manager, ProfilerFiller profiler) {
        DynamicOps ops = Optional.ofNullable(this.registryAccess).map(it -> RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)it)).orElse((DynamicOps)JsonOps.INSTANCE);
        Codec codec = this.codec();
        ImmutableMap.Builder entries = new ImmutableMap.Builder();
        elements.forEach((id, json) -> {
            try {
                Optional result = codec.parse(ops, json).resultOrPartial(arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
                result.ifPresent(value -> entries.put(id, value));
            }
            catch (Exception e) {
                Constants.LOGGER.error("encountered an exception loading '{}': {}", id, (Object)e);
            }
        });
        this.consume((Map<ResourceLocation, T>)entries.build());
    }

    protected abstract void consume(Map<ResourceLocation, T> var1);
}

