/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.content_packs.forge;

import com.possible_triangle.content_packs.ClientClass;
import com.possible_triangle.content_packs.CommonClass;
import com.possible_triangle.content_packs.platform.RegistryEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegisterEvent;

public class ForgeRegistryCache
implements RegistryEvent {
    private final Set<FactoryEntry<?>> factories = new HashSet();
    private final Map<ResourceKey<CreativeModeTab>, Collection<Supplier<ItemStack>>> tabs = new HashMap<ResourceKey<CreativeModeTab>, Collection<Supplier<ItemStack>>>();
    private boolean loaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RegisterEvent event) {
        if (event.getRegistryKey().m_135782_().m_135827_().equals("content_packs")) {
            return;
        }
        if (!this.loaded) {
            this.load();
        }
        Set<FactoryEntry<?>> set = this.factories;
        synchronized (set) {
            this.factories.forEach(it -> it.register(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTabs(BuildCreativeModeTabContentsEvent event) {
        Map<ResourceKey<CreativeModeTab>, Collection<Supplier<ItemStack>>> map = this.tabs;
        synchronized (map) {
            Collection<Supplier<ItemStack>> items = this.tabs.get(event.getTabKey());
            if (items != null) {
                items.forEach(it -> event.m_246342_((ItemStack)it.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R extends T> Supplier<R> register(ResourceKey<Registry<T>> registry, ResourceLocation id, Supplier<R> factory) {
        Object value = factory.get();
        Set<FactoryEntry<?>> set = this.factories;
        synchronized (set) {
            this.factories.add(new FactoryEntry<T>(registry, id, value));
        }
        return () -> value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToTab(ResourceKey<CreativeModeTab> tab, Supplier<ItemStack> supplier) {
        Map<ResourceKey<CreativeModeTab>, Collection<Supplier<ItemStack>>> map = this.tabs;
        synchronized (map) {
            this.tabs.computeIfAbsent(tab, $ -> new ArrayList()).add(supplier);
        }
    }

    private void load() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientClass.clientInit(this));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> CommonClass.serverInit(this));
        this.loaded = true;
    }

    public record FactoryEntry<T>(ResourceKey<Registry<T>> registry, ResourceLocation id, T value) {
        void register(RegisterEvent event) {
            event.register(this.registry(), this.id(), this::value);
        }
    }
}

