/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.content_packs.loader.definition.item;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.possible_triangle.content_packs.Constants;
import com.possible_triangle.content_packs.ModRegistries;
import com.possible_triangle.content_packs.loader.definition.item.ItemProperties;
import com.possible_triangle.content_packs.platform.RegistryEvent;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class ItemDefinition {
    public static final Codec<ItemDefinition> CODEC = ExtraCodecs.m_184415_(() -> ModRegistries.ITEM_TYPES.byNameCodec().dispatchStable(ItemDefinition::codec, Function.identity()));
    protected final ItemProperties properties;

    public static <T extends ItemDefinition> Products.P1<RecordCodecBuilder.Mu<T>, ItemProperties> commonCodec(RecordCodecBuilder.Instance<T> builder) {
        return builder.group((App)ItemProperties.CODEC.optionalFieldOf("properties", (Object)ItemProperties.DEFAULT).forGetter(it -> it.properties));
    }

    protected ItemDefinition(ItemProperties properties) {
        this.properties = properties;
    }

    public abstract Codec<? extends ItemDefinition> codec();

    protected abstract Item create(RegistryEvent var1, ResourceLocation var2);

    public final Supplier<Item> register(RegistryEvent event, ResourceLocation id) {
        return event.register(Registries.f_256913_, id, () -> {
            Constants.LOGGER.debug("registering item with id {}", (Object)id);
            Item registered = this.create(event, id);
            event.addToTab(this.properties.creativeTabKey(), () -> new ItemStack((ItemLike)registered));
            return registered;
        });
    }
}

