/*
 * Decompiled with CFR 0.152.
 */
package yancey.bbsaekeyframe.util;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import mchorse.bbs_mod.camera.Camera;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AEKeyframeGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    public static String lastKeyframeStr = null;
    private int videoHeight;
    private Path path;
    private StringBuilder aeKeyframeStr;
    private StringBuilder zoomStr;
    private StringBuilder expressionStr;
    private StringBuilder orientationStr;
    private StringBuilder positionStr;
    private int count;

    public void startRecording(Path path, int videoWidth, int videoHeight, double frameRate) {
        this.path = path;
        this.videoHeight = videoHeight;
        this.aeKeyframeStr = new StringBuilder();
        this.zoomStr = new StringBuilder();
        this.expressionStr = new StringBuilder();
        this.orientationStr = new StringBuilder();
        this.positionStr = new StringBuilder();
        this.count = 0;
        this.aeKeyframeStr.append("Adobe After Effects 8.0 Keyframe Data\n");
        this.aeKeyframeStr.append(String.format("\tUnits Per Second\t%.2f\n", frameRate));
        this.aeKeyframeStr.append(String.format("\tSource Width\t%d\n", videoWidth));
        this.aeKeyframeStr.append(String.format("\tSource Height\t%d\n", videoHeight));
        this.aeKeyframeStr.append("\tSource Pixel Aspect Ratio\t1\n\tComp Pixel Aspect Ratio\t1\n");
        this.zoomStr.append("Camera Options\tZoom\n\tFrame\n");
        this.expressionStr.append("Expression Data\n// Keep fov value when scaling composite.\n");
        this.expressionStr.append(String.format("thisComp.height / %d * cameraOption.zoom\n", videoHeight));
        this.expressionStr.append("End of Expression Data\nTransform\tPoint of Interest\n\tFrame\n\t\t0\t0\t0\nExpression Data\n// These tracking data only support one-node camera\ntransform.position\nEnd of Expression Data\n");
        this.orientationStr.append("Transform\tOrientation\n\tFrame\n");
        this.positionStr.append("Transform\tPosition\n\tFrame\n");
    }

    public void stopRecording() {
        this.aeKeyframeStr.append((CharSequence)this.zoomStr);
        this.aeKeyframeStr.append((CharSequence)this.expressionStr);
        this.aeKeyframeStr.append((CharSequence)this.orientationStr);
        this.aeKeyframeStr.append((CharSequence)this.positionStr);
        this.aeKeyframeStr.append("End of Keyframe Data\n");
        lastKeyframeStr = this.aeKeyframeStr.toString();
        try {
            Files.writeString(this.path, (CharSequence)lastKeyframeStr, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write keyframe data to file", (Throwable)e);
        }
    }

    public void recordFrame(Camera camera) {
        this.zoomStr.append('\t').append(this.count).append('\t').append((double)this.videoHeight / 2.0 / Math.tan(camera.fov / 2.0f)).append('\n');
        Matrix4f mat = new Matrix4f().rotateX((float)Math.PI).rotateY(camera.rotation.y).rotateX(-camera.rotation.x).rotateZ(camera.rotation.z);
        Vector3f rotation = new Vector3f();
        mat.getEulerAnglesXYZ(rotation);
        this.orientationStr.append('\t').append(this.count).append('\t').append(Math.toDegrees(rotation.x)).append('\t').append(Math.toDegrees(rotation.y)).append('\t').append(Math.toDegrees(rotation.z)).append('\n');
        this.positionStr.append('\t').append(this.count).append('\t').append(camera.position.x).append('\t').append(camera.position.y).append('\t').append(camera.position.z).append('\n');
        ++this.count;
    }
}

