/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.common.block;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public abstract class BedrockCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public static final Predicate<Biome.Precipitation> NONE = precipitation -> false;

    public BedrockCauldronBlock(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> cauldronInteractions) {
        super(properties, NONE, cauldronInteractions);
    }

    public abstract int getColor(BlockAndTintGetter var1, BlockPos var2);

    public Item m_5456_() {
        return Items.f_42544_;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean areBreakingParticlesTinted(BlockState state, ClientLevel level, BlockPos pos) {
                return false;
            }
        });
    }

    public static double getCauldronContentHeight(BlockState blockstate) {
        return blockstate.m_60713_(Blocks.f_50256_) ? 0.25 : (6.0 + (double)((Integer)blockstate.m_61143_((Property)f_153514_)).intValue() * 3.0) / 16.0;
    }

    public static void lowerFillLevelBy(BlockState blockstate, Level level, BlockPos blockpos, int lowerAmount) {
        int i = (Integer)blockstate.m_61143_((Property)f_153514_) - lowerAmount;
        BlockState resultblockstate = i == 0 ? Blocks.f_50256_.m_49966_() : (BlockState)blockstate.m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(i));
        level.m_46597_(blockpos, resultblockstate);
        level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223722_((BlockState)resultblockstate));
    }
}

