/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.common.block.entity;

import lagz.bedrock_cauldrons.core.registry.BCBlockEntityTypes;
import lagz.bedrock_cauldrons.core.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DyeCauldronBlockEntity
extends BlockEntity {
    private int color = -1;

    public DyeCauldronBlockEntity(BlockPos blockpos, BlockState blockstate) {
        super((BlockEntityType)BCBlockEntityTypes.DYE_CAULDRON.get(), blockpos, blockstate);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("color", this.color);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.color = tag.m_128425_("color", 3) ? tag.m_128451_("color") : -1;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.m_6596_();
    }

    public void setColor(DyeItem dyeitem) {
        this.setColor(ColorUtil.getDyeColor(dyeitem));
    }

    public void setColorAndUpdate(int color) {
        this.setColor(color);
        Level level = this.m_58904_();
        assert (level != null) : "Level should never be null when a player is interacting with blockentity";
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public boolean isSameColor(int color) {
        return this.color == color;
    }

    public boolean isSameColor(DyeItem dyeitem) {
        return this.isSameColor(ColorUtil.getDyeColor(dyeitem));
    }

    public int getColorMixResult(DyeItem dyeitem) {
        return ColorUtil.averageIntColors(this.color, ColorUtil.getDyeColor(dyeitem));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Level level = this.m_58904_();
        assert (level != null) : "Level should never be null when a blockentity is receiving a data packet";
        if (level.f_46443_) {
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

