/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.common.block.entity;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lagz.bedrock_cauldrons.core.registry.BCBlockEntityTypes;
import lagz.bedrock_cauldrons.core.util.TagUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionCauldronBlockEntity
extends BlockEntity {
    protected static final Supplier<ItemStack> DEFAULT_POTION_STACK = () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
    private ItemStack potionStack = DEFAULT_POTION_STACK.get();

    public PotionCauldronBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)BCBlockEntityTypes.POTION_CAULDRON.get(), p_155229_, p_155230_);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("potion", (Tag)this.potionStack.m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        ItemStack itemstack;
        super.m_142466_(tag);
        if (tag.m_128425_("potion", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("potion"))).m_41619_()) {
            this.potionStack = PotionCauldronBlockEntity.copyStackLimitTags(itemstack);
        }
    }

    public Potion getPotion() {
        return PotionUtils.m_43579_((ItemStack)this.potionStack);
    }

    public int getPotionColor() {
        return PotionUtils.m_43575_((ItemStack)this.potionStack);
    }

    @Nullable
    public CompoundTag getPotionTag() {
        return this.potionStack.m_41783_();
    }

    public boolean isUncoloredWater() {
        if (this.getPotion() != Potions.f_43599_) {
            return false;
        }
        CompoundTag tag = this.potionStack.m_41783_();
        if (tag != null) {
            if (tag.m_128425_("CustomPotionColor", 99)) {
                return false;
            }
            if (tag.m_128425_("CustomPotionEffects", 9)) {
                return tag.m_128437_("CustomPotionEffects", 10).isEmpty();
            }
        }
        return true;
    }

    public static boolean hasCustomEffectsOrColor(ItemStack itemstack) {
        CompoundTag tag = itemstack.m_41783_();
        if (tag == null) {
            return false;
        }
        if (tag.m_128425_("CustomPotionColor", 99)) {
            return true;
        }
        if (tag.m_128425_("CustomPotionEffects", 9)) {
            return !tag.m_128437_("CustomPotionEffects", 10).isEmpty();
        }
        return false;
    }

    public boolean isWaterWithoutEffects() {
        return this.getPotion() == Potions.f_43599_ && PotionUtils.m_43547_((ItemStack)this.potionStack).isEmpty();
    }

    public boolean hasParticles() {
        return !this.isWaterWithoutEffects();
    }

    protected void setPotionStack(ItemStack stack) {
        this.potionStack = stack;
        this.m_6596_();
    }

    public void initPotionStack(ItemStack initStack) {
        this.setPotionStack(PotionCauldronBlockEntity.copyStackLimitTags(initStack));
    }

    protected static ItemStack copyStackLimitTags(ItemStack itemstack) {
        ItemStack copyStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)itemstack.m_41720_()), (Potion)PotionUtils.m_43579_((ItemStack)itemstack));
        CompoundTag tag = itemstack.m_41783_();
        if (tag != null) {
            ListTag customEffects;
            if (tag.m_128425_("CustomPotionColor", 99)) {
                copyStack.m_41784_().m_128405_("CustomPotionColor", tag.m_128451_("CustomPotionColor"));
            }
            if (tag.m_128425_("CustomPotionEffects", 9) && !(customEffects = tag.m_128437_("CustomPotionEffects", 10)).isEmpty()) {
                copyStack.m_41784_().m_128365_("CustomPotionEffects", (Tag)customEffects.m_6426_());
            }
        }
        return copyStack;
    }

    public void initRandomSwampHutPotionStack(RandomSource random) {
        this.setPotionStack(PotionCauldronBlockEntity.createRandomSwampHutPotionStack(random));
    }

    public ItemStack createPickupStack() {
        return PotionCauldronBlockEntity.copyStackLimitTags(this.potionStack);
    }

    public static ItemStack createRandomSwampHutPotionStack(RandomSource random) {
        Item item = random.m_188503_(2) == 0 ? Items.f_42589_ : Items.f_42736_;
        ItemStack potionStack = new ItemStack((ItemLike)item);
        List<Potion> potions = ForgeRegistries.POTIONS.getValues().stream().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).toList();
        Potion potion2 = potions.get(random.m_188503_(potions.size()));
        return PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion2);
    }

    public boolean potionStackEquals(ItemStack stack) {
        CompoundTag otherTag;
        CompoundTag thisTag;
        if (this.potionStack.m_150930_(stack.m_41720_()) && this.getPotion() == PotionUtils.m_43579_((ItemStack)stack) && TagUtil.tagsContainEqualIntTag(thisTag = this.potionStack.m_41783_(), otherTag = stack.m_41783_(), "CustomPotionColor")) {
            return TagUtil.tagsContainEqualListTag(thisTag, otherTag, "CustomPotionEffects", (byte)10);
        }
        return false;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Level level = this.m_58904_();
        assert (level != null) : "Level should never be null when a blockentity is receiving a data packet";
        if (level.f_46443_) {
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

