/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.core.other;

import java.util.Map;
import lagz.bedrock_cauldrons.common.block.BedrockCauldronBlock;
import lagz.bedrock_cauldrons.common.block.entity.DyeCauldronBlockEntity;
import lagz.bedrock_cauldrons.common.block.entity.PotionCauldronBlockEntity;
import lagz.bedrock_cauldrons.core.networking.BCNetworking;
import lagz.bedrock_cauldrons.core.registry.BCBlocks;
import lagz.bedrock_cauldrons.core.registry.BCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BCCauldronInteractions {
    public static final Map<Item, CauldronInteraction> POTION = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> DYE = CauldronInteraction.m_175617_();
    public static final CauldronInteraction EMPTY_FILL_POTION = (state, level, pos, player, hand, stack) -> {
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            BlockState placeBlockState = ((Block)BCBlocks.POTION_CAULDRON.get()).m_49966_();
            level.m_46597_(pos, placeBlockState);
            BlockEntity patt3263$temp = level.m_7702_(pos);
            if (patt3263$temp instanceof PotionCauldronBlockEntity) {
                PotionCauldronBlockEntity entity = (PotionCauldronBlockEntity)patt3263$temp;
                entity.initPotionStack(stack);
                if (entity.hasParticles()) {
                    BCNetworking.sendAddPotionInteractParticlesMessage(level, pos, entity.getPotionColor(), BedrockCauldronBlock.getCauldronContentHeight(placeBlockState));
                }
            }
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };
    public static final CauldronInteraction WATER_FILL_POTION = (state, level, pos, player, hand, stack) -> {
        if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3) {
            return BCCauldronInteractions.mixPotions(level, pos, player, hand, stack);
        }
        return InteractionResult.PASS;
    };
    public static final CauldronInteraction WATER_DYE = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeitem = (DyeItem)item;
            if (!level.f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                int waterLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                level.m_46597_(pos, (BlockState)((Block)BCBlocks.DYE_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel)));
                BlockEntity patt5179$temp = level.m_7702_(pos);
                if (patt5179$temp instanceof DyeCauldronBlockEntity) {
                    DyeCauldronBlockEntity entity = (DyeCauldronBlockEntity)patt5179$temp;
                    entity.setColor(dyeitem);
                }
                level.m_5594_(null, pos, (SoundEvent)BCSoundEvents.DYE_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157792_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    };
    public static final CauldronInteraction FILL_POTION = (state, level, pos, player, hand, stack) -> {
        BlockEntity patt8993$temp;
        if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3 && (patt8993$temp = level.m_7702_(pos)) instanceof PotionCauldronBlockEntity) {
            PotionCauldronBlockEntity entity = (PotionCauldronBlockEntity)patt8993$temp;
            if (entity.potionStackEquals(stack)) {
                if (!level.f_46443_) {
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    BlockState placeBlockState = (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_);
                    level.m_46597_(pos, placeBlockState);
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157769_, pos);
                    if (entity.hasParticles()) {
                        BCNetworking.sendAddPotionInteractParticlesMessage(level, pos, entity.getPotionColor(), BedrockCauldronBlock.getCauldronContentHeight(placeBlockState));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return BCCauldronInteractions.mixPotions(level, pos, player, hand, stack);
        }
        return InteractionResult.PASS;
    };
    public static final CauldronInteraction MIX_DYE = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeitem = (DyeItem)item;
            BlockEntity patt15340$temp = level.m_7702_(pos);
            if (patt15340$temp instanceof DyeCauldronBlockEntity) {
                DyeCauldronBlockEntity entity = (DyeCauldronBlockEntity)patt15340$temp;
                int resultColor = entity.getColorMixResult(dyeitem);
                if (!entity.isSameColor(dyeitem) && !entity.isSameColor(resultColor)) {
                    if (!level.f_46443_) {
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                        entity.setColorAndUpdate(resultColor);
                        level.m_5594_(null, pos, (SoundEvent)BCSoundEvents.DYE_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_142346_(null, GameEvent.f_157792_, pos);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    };
    public static final CauldronInteraction DYEABLE_ITEM = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeableleatheritem = (DyeableLeatherItem)item;
            BlockEntity patt16636$temp = level.m_7702_(pos);
            if (patt16636$temp instanceof DyeCauldronBlockEntity) {
                DyeCauldronBlockEntity entity = (DyeCauldronBlockEntity)patt16636$temp;
                if (dyeableleatheritem.m_41121_(stack) != entity.getColor()) {
                    if (!level.f_46443_) {
                        dyeableleatheritem.m_41115_(stack, entity.getColor());
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                        LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                        level.m_5594_(null, pos, (SoundEvent)BCSoundEvents.DYE_ITEM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    };
    public static final CauldronInteraction DYE_FILL_POTION = (state, level, pos, player, hand, stack) -> {
        if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3) {
            if (stack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_ && !PotionCauldronBlockEntity.hasCustomEffectsOrColor(stack)) {
                if (!level.f_46443_) {
                    Item item = stack.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    int dyeLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                    level.m_46597_(pos, (BlockState)((BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(dyeLevel))).m_61122_((Property)LayeredCauldronBlock.f_153514_));
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157769_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return BCCauldronInteractions.mixPotions(level, pos, player, hand, stack);
        }
        return InteractionResult.PASS;
    };

    public static void registerCauldronInteractions() {
        BCCauldronInteractions.registerVanillaCauldronInteractions();
        BCCauldronInteractions.registerPotionCauldronInteractions();
        BCCauldronInteractions.registerDyeCauldronInteractions();
    }

    private static InteractionResult mixPotions(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(null, pos, (SoundEvent)BCSoundEvents.POTION_EVAPORATE.get(), SoundSource.BLOCKS, 1.0f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
            BCNetworking.sendAddPotionEvaporateParticlesMessage(level, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static void registerVanillaCauldronInteractions() {
        CauldronInteraction.f_175606_.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_ || PotionCauldronBlockEntity.hasCustomEffectsOrColor(stack)) {
                return EMPTY_FILL_POTION.m_175710_(state, level, pos, player, hand, stack);
            }
            if (!level.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                level.m_46597_(pos, Blocks.f_152476_.m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        CauldronInteraction.f_175606_.put(Items.f_42736_, EMPTY_FILL_POTION);
        CauldronInteraction.f_175606_.put(Items.f_42739_, EMPTY_FILL_POTION);
        CauldronInteraction.f_175607_.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3) {
                if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_ && !PotionCauldronBlockEntity.hasCustomEffectsOrColor(stack)) {
                    if (!level.f_46443_) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        level.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                        level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_142346_(null, GameEvent.f_157769_, pos);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return BCCauldronInteractions.mixPotions(level, pos, player, hand, stack);
            }
            return InteractionResult.PASS;
        });
        CauldronInteraction.f_175607_.put(Items.f_42736_, WATER_FILL_POTION);
        CauldronInteraction.f_175607_.put(Items.f_42739_, WATER_FILL_POTION);
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeItem).forEach(item -> CauldronInteraction.f_175607_.put(item, WATER_DYE));
    }

    private static void registerPotionCauldronInteractions() {
        CauldronInteraction.m_175647_(POTION);
        POTION.put(Items.f_42590_, (state, level, pos, player, hand, stack) -> {
            BlockEntity patt10551$temp = level.m_7702_(pos);
            if (patt10551$temp instanceof PotionCauldronBlockEntity) {
                PotionCauldronBlockEntity entity = (PotionCauldronBlockEntity)patt10551$temp;
                if (!level.f_46443_) {
                    Item item = stack.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)entity.createPickupStack()));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157816_, pos);
                    if (entity.hasParticles()) {
                        BCNetworking.sendAddPotionInteractParticlesMessage(level, pos, entity.getPotionColor(), BedrockCauldronBlock.getCauldronContentHeight(level.m_8055_(pos)));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
        POTION.put(Items.f_42589_, FILL_POTION);
        POTION.put(Items.f_42736_, FILL_POTION);
        POTION.put(Items.f_42739_, FILL_POTION);
        POTION.put(Items.f_42412_, (state, level, pos, player, hand, stack) -> {
            BlockEntity patt11923$temp = level.m_7702_(pos);
            if (patt11923$temp instanceof PotionCauldronBlockEntity) {
                PotionCauldronBlockEntity entity = (PotionCauldronBlockEntity)patt11923$temp;
                if (!level.f_46443_) {
                    Item item = stack.m_41720_();
                    int maxTippedArrows = switch ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)) {
                        case 2 -> 32;
                        case 3 -> 64;
                        default -> 16;
                    };
                    int tippedArrowCount = Math.min(stack.m_41613_(), maxTippedArrows);
                    ItemStack tippedArrowStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_, tippedArrowCount), (Potion)entity.getPotion());
                    CompoundTag potionTag = entity.getPotionTag();
                    if (potionTag != null) {
                        ListTag customEffects;
                        if (potionTag.m_128425_("CustomPotionColor", 99)) {
                            tippedArrowStack.m_41784_().m_128405_("CustomPotionColor", potionTag.m_128451_("CustomPotionColor"));
                        }
                        if (potionTag.m_128425_("CustomPotionEffects", 9) && !(customEffects = potionTag.m_128437_("CustomPotionEffects", 10)).isEmpty()) {
                            tippedArrowStack.m_41784_().m_128365_("CustomPotionEffects", (Tag)customEffects.m_6426_());
                        }
                    }
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(tippedArrowCount);
                    }
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, tippedArrowStack);
                    } else if (!player.m_150109_().m_36054_(tippedArrowStack)) {
                        player.m_36176_(tippedArrowStack, false);
                    }
                    player.m_6278_(Stats.f_12982_.m_12902_((Object)item), tippedArrowCount);
                    int levelsUsed = tippedArrowCount <= 16 ? 1 : (tippedArrowCount <= 32 ? 2 : 3);
                    BedrockCauldronBlock.lowerFillLevelBy(state, level, pos, levelsUsed);
                    level.m_5594_(null, pos, (SoundEvent)BCSoundEvents.TIP_ARROWS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (entity.hasParticles()) {
                        BCNetworking.sendAddPotionInteractParticlesMessage(level, pos, entity.getPotionColor(), BedrockCauldronBlock.getCauldronContentHeight(level.m_8055_(pos)));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }

    private static void registerDyeCauldronInteractions() {
        CauldronInteraction.m_175647_(DYE);
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeItem).forEach(item -> DYE.put((Item)item, MIX_DYE));
        DYE.put(Items.f_42463_, DYEABLE_ITEM);
        DYE.put(Items.f_42462_, DYEABLE_ITEM);
        DYE.put(Items.f_42408_, DYEABLE_ITEM);
        DYE.put(Items.f_42407_, DYEABLE_ITEM);
        DYE.put(Items.f_42654_, DYEABLE_ITEM);
        DYE.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)Items.f_42447_), blockstate -> (Integer)blockstate.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, (SoundEvent)SoundEvents.f_11781_));
        DYE.put(Items.f_42590_, (state, level, pos, player, hand, stack) -> {
            if (!level.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        DYE.put(Items.f_42589_, DYE_FILL_POTION);
        DYE.put(Items.f_42736_, DYE_FILL_POTION);
        DYE.put(Items.f_42739_, DYE_FILL_POTION);
    }
}

