/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.core.util;

import net.minecraft.world.item.DyeItem;

public class ColorUtil {
    public static int getDyeColor(DyeItem dyeitem) {
        return ColorUtil.floatColorToIntColor(dyeitem.m_41089_().m_41068_());
    }

    public static float[] intColorToFloatColor(int color) {
        float[] floatColor = new float[]{(float)((color & 0xFF0000) >> 16) / 255.0f, (float)((color & 0xFF00) >> 8) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return floatColor;
    }

    public static int floatColorToIntColor(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        int intColor = (r << 8) + g;
        return (intColor << 8) + b;
    }

    public static int averageIntColors(int ... colors) {
        int[] addedColors = new int[3];
        int addedMaxColor = 0;
        int colorCount = colors.length;
        if (colorCount == 2 && colors[0] == -1) {
            return colors[1];
        }
        for (int color : colors) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            addedMaxColor += Math.max(r, Math.max(g, b));
            addedColors[0] = addedColors[0] + r;
            addedColors[1] = addedColors[1] + g;
            addedColors[2] = addedColors[2] + b;
        }
        int averageRed = addedColors[0] / colorCount;
        int averageGreen = addedColors[1] / colorCount;
        int averageBlue = addedColors[2] / colorCount;
        float averageMaxColor = (float)addedMaxColor / (float)colorCount;
        float maxAveragedColor = Math.max(averageRed, Math.max(averageGreen, averageBlue));
        averageRed = (int)((float)averageRed * averageMaxColor / maxAveragedColor);
        averageGreen = (int)((float)averageGreen * averageMaxColor / maxAveragedColor);
        averageBlue = (int)((float)averageBlue * averageMaxColor / maxAveragedColor);
        int averageColor = (averageRed << 8) + averageGreen;
        averageColor = (averageColor << 8) + averageBlue;
        return averageColor;
    }
}

