/*
 * Decompiled with CFR 0.152.
 */
package lagz.bedrock_cauldrons.core.util;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class TagUtil {
    public static boolean tagsContainEqualIntTag(@Nullable CompoundTag tag1, @Nullable CompoundTag tag2, String key) {
        return TagUtil.tagsContainEqualTag(tag1, tag2, key, (byte)99, CompoundTag::m_128451_, integer -> false);
    }

    public static boolean tagsContainEqualListTag(@Nullable CompoundTag tag1, @Nullable CompoundTag tag2, String key, byte listType) {
        return TagUtil.tagsContainEqualTag(tag1, tag2, key, (byte)9, (tag, k) -> tag.m_128437_(k, (int)listType), ListTag::isEmpty);
    }

    public static <T> boolean tagsContainEqualTag(@Nullable CompoundTag tag1, @Nullable CompoundTag tag2, String key, byte type, BiFunction<CompoundTag, String, T> getValue, Predicate<T> isEmpty) {
        boolean tag2Null;
        boolean tag1Null = tag1 == null;
        boolean bl = tag2Null = tag2 == null;
        if (tag1Null ^ tag2Null) {
            CompoundTag nonNullTag = tag2Null ? tag1 : tag2;
            return !nonNullTag.m_128425_(key, (int)type) || isEmpty.test(getValue.apply(nonNullTag, key));
        }
        if (tag1Null) {
            return true;
        }
        boolean tag1Contains = tag1.m_128425_(key, (int)type);
        boolean tag2Contains = tag2.m_128425_(key, (int)type);
        if (tag1Contains && tag2Contains) {
            return getValue.apply(tag1, key).equals(getValue.apply(tag2, key));
        }
        if (!tag1Contains && !tag2Contains) {
            return true;
        }
        CompoundTag containingTag = tag1Contains ? tag1 : tag2;
        return isEmpty.test(getValue.apply(containingTag, key));
    }
}

