/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.debug;

import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.gizmos.GizmoProperties;
import net.minecraft.gizmos.Gizmos;
import net.minecraft.util.debug.DebugValueAccess;
import net.minecraft.world.phys.Vec3;

public class RaycastRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final List<Ray> rays = Collections.synchronizedList(new ArrayList());
    private static final Minecraft mc = Minecraft.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitGizmos(double d, double e, double f, DebugValueAccess debugValueAccess, Frustum frustum, float g) {
        if (RaycastRenderer.mc.level == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue() && !SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            List<Ray> list = rays;
            synchronized (list) {
                rays.clear();
            }
            return;
        }
        long gameTime = RaycastRenderer.mc.level.getGameTime();
        List<Ray> list = rays;
        synchronized (list) {
            rays.removeIf(ray -> gameTime - ray.tickCreated > (long)ray.lifespan || gameTime - ray.tickCreated < 0L);
            for (Ray ray2 : rays) {
                GizmoProperties line = Gizmos.line((Vec3)ray2.start, (Vec3)ray2.end, (int)ray2.color);
                line.persistForMillis(ray2.lifespan * 50);
                line.fadeOut();
                if (!ray2.throughWalls) continue;
                line.setAlwaysOnTop();
            }
        }
    }

    public static int color(ChatFormatting color) {
        Integer colorValue = color.getColor();
        if (colorValue == null) {
            return -16777216;
        }
        return colorValue | 0xFF000000;
    }

    public static void addSoundBounceRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, false);
    }

    public static void addOcclusionRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRay(Vec3 start, Vec3 end, int color, boolean throughWalls) {
        if (RaycastRenderer.mc.player.position().distanceTo(start) > 32.0 && RaycastRenderer.mc.player.position().distanceTo(end) > 32.0) {
            return;
        }
        List<Ray> list = rays;
        synchronized (list) {
            rays.add(new Ray(start, end, color, throughWalls));
        }
    }

    private static class Ray {
        private final Vec3 start;
        private final Vec3 end;
        private final int color;
        private final long tickCreated;
        private final int lifespan;
        private final boolean throughWalls;

        public Ray(Vec3 start, Vec3 end, int color, boolean throughWalls) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.throughWalls = throughWalls;
            this.tickCreated = RaycastRenderer.mc.level.getGameTime();
            this.lifespan = 40;
        }
    }
}

