/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.utils;

import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.Identifier;

public class SoundRateManager {
    private static final Map<Identifier, Integer> soundCounts = new ConcurrentHashMap<Identifier, Integer>();
    private static boolean worldInitialized;

    private SoundRateManager() {
    }

    public static boolean incrementAndCheckLimit(Identifier sound) {
        int max;
        int count = soundCounts.getOrDefault(sound, 0);
        if (count >= (max = SoundPhysicsMod.SOUND_RATE_CONFIG.getMaxCount(sound).intValue())) {
            return true;
        }
        soundCounts.put(sound, count + 1);
        return false;
    }

    public static boolean isWorldInitialized() {
        return worldInitialized;
    }

    public static void onClientTick(ClientLevel level) {
        SoundRateManager.clear();
        worldInitialized = true;
    }

    public static void clear() {
        soundCounts.clear();
    }

    public static void onLoadLevel(ClientLevel clientLevel) {
        SoundRateManager.clear();
        worldInitialized = false;
    }

    public static void onUnloadLevel(ClientLevel clientLevel) {
        SoundRateManager.clear();
        worldInitialized = false;
    }
}

