/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.commands;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.map.VaultMapOverlayRenderer;
import com.nodiumhosting.vaultmapper.map.snapshots.MapCache;
import com.nodiumhosting.vaultmapper.map.snapshots.MapSnapshot;
import com.nodiumhosting.vaultmapper.util.Util;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.server.command.EnumArgument;

public class VaultMapperCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vaultmapper").executes(VaultMapperCommand::execute)).then(Commands.m_82127_((String)"enable").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"disable").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"reset").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"enabledebug").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"disabledebug").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"openByVaultId").then(Commands.m_82129_((String)"vaultId", (ArgumentType)StringArgumentType.string()).executes(VaultMapperCommand::execute)))).then(Commands.m_82127_((String)"dumpColumn").then(Commands.m_82129_((String)"column", (ArgumentType)EnumArgument.enumArgument(Column.class)).executes(VaultMapperCommand::execute)))).then(Commands.m_82127_((String)"dumpMapCellData").executes(VaultMapperCommand::execute))).then(Commands.m_82127_((String)"dumpCurrentCellData").executes(VaultMapperCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> command) {
        Entity entity = ((CommandSourceStack)command.getSource()).m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String[] args = command.getInput().split(" ");
            if (args.length > 1) {
                if (args[1].equals("enable")) {
                    VaultMap.resetMap();
                    VaultMap.enabled = true;
                    VaultMapOverlayRenderer.enabled = true;
                    MapCache.readCache();
                    player.m_6352_((Component)new TextComponent("Vault Mapper enabled"), player.m_142081_());
                } else if (args[1].equals("disable")) {
                    VaultMapOverlayRenderer.enabled = false;
                    VaultMap.enabled = false;
                    player.m_6352_((Component)new TextComponent("Vault Mapper disabled"), player.m_142081_());
                } else if (args[1].equals("reset")) {
                    VaultMap.resetMap();
                    player.m_6352_((Component)new TextComponent("Vault Mapper reset"), player.m_142081_());
                } else if (args[1].equals("enabledebug")) {
                    VaultMap.debug = true;
                } else if (args[1].equals("disabledebug")) {
                    VaultMap.debug = false;
                } else if (args[1].equals("openByVaultId")) {
                    if (args.length > 2) {
                        RenderSystem.m_69879_(() -> MapSnapshot.openScreen(args[2]));
                    } else {
                        player.m_6352_((Component)new TextComponent("Usage: /vaultmapper openByVaultId <vaultId>"), player.m_142081_());
                    }
                } else if (args[1].equals("dumpColumn")) {
                    if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault")) {
                        return 0;
                    }
                    int blockX = 23;
                    int blockZ = 23;
                    switch (args[2]) {
                        case "MIDDLE": {
                            blockX = 23;
                            blockZ = 23;
                            break;
                        }
                        case "NORTHWEST": {
                            blockX = 0;
                            blockZ = 0;
                            break;
                        }
                        case "NORTHEAST": {
                            blockX = 46;
                            blockZ = 0;
                            break;
                        }
                        case "SOUTHWEST": {
                            blockX = 0;
                            blockZ = 46;
                            break;
                        }
                        case "SOUTHEAST": {
                            blockX = 46;
                            blockZ = 46;
                        }
                    }
                    VaultCell currentCell = VaultMap.getCurrentCell();
                    HashMap<Integer, String> middleColumn = new HashMap<Integer, String>();
                    for (int i = 9; i <= 55; ++i) {
                        Block block = VaultMap.getCellBlock(currentCell.x, currentCell.z, blockX, i, blockZ);
                        if (block == null) continue;
                        middleColumn.put(i, block.getRegistryName().toString());
                    }
                    String json = Util.GSON.toJson(middleColumn);
                    Minecraft.m_91087_().f_91068_.m_90911_(json);
                } else if (args[1].equals("dumpMapCellData")) {
                    if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault")) {
                        return 0;
                    }
                    String json = Util.GSON.toJson(VaultMap.cells);
                    Minecraft.m_91087_().f_91068_.m_90911_(json);
                    player.m_6352_((Component)new TextComponent(json), player.m_142081_());
                } else if (args[1].equals("dumpCurrentCellData")) {
                    if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault")) {
                        return 0;
                    }
                    VaultCell currentCell = VaultMap.getCurrentCell();
                    String json = Util.GSON.toJson((Object)currentCell);
                    Minecraft.m_91087_().f_91068_.m_90911_(json);
                    player.m_6352_((Component)new TextComponent(json), player.m_142081_());
                } else {
                    player.m_6352_((Component)new TextComponent("Usage: /vaultmapper <enable|disable|reset|enabledebug|disabledebug|openByVaultId|dumpColumn>"), player.m_142081_());
                }
            } else {
                player.m_6352_((Component)new TextComponent("Usage: /vaultmapper <enable|disable|reset|enabledebug|disabledebug|openByVaultId|dumpColumn>"), player.m_142081_());
            }
        }
        return 1;
    }

    static enum Column {
        MIDDLE,
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

