/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nodiumhosting.vaultmapper.gui.component.ColorButton;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ColorPicker
extends Button {
    private int selectedColor;
    private int selectedX;
    private int selectedY;

    public ColorPicker(int x, int y, int width, int height, int selectedColor, Button.OnPress pOnPress) {
        super(x, y, width, height, (Component)new TextComponent(""), pOnPress);
        this.selectedColor = selectedColor;
    }

    private static Color getColor(int w, int h, int i, int j) {
        Color c = j < h / 9 * 4 ? new Color(Color.HSBtoRGB((float)i / (float)w, (float)j / (float)(h / 9 * 4), 1.0f)) : (j < h / 9 * 8 ? new Color(Color.HSBtoRGB((float)i / (float)w, 1.0f, 1.0f - (float)(j - h / 9 * 4) / (float)(h / 9 * 4))) : new Color(Color.HSBtoRGB(0.0f, 0.0f, 1.0f - (float)i / (float)w)));
        return c;
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_93624_) {
            int j;
            int i;
            GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)(this.m_93696_() ? -1 : -6250336));
            GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-16777216);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int startX = this.f_93620_ + 1;
            int startY = this.f_93621_ + 1;
            int w = this.f_93618_ - 2;
            int h = this.f_93619_ - 2;
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    Color c = ColorPicker.getColor(w, h, i, j);
                    int color = c.getAlpha() << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
                    bufferBuilder.m_5483_((double)(startX + i), (double)(startY + j + 1), 0.0).m_193479_(color).m_5752_();
                    bufferBuilder.m_5483_((double)(startX + i + 1), (double)(startY + j + 1), 0.0).m_193479_(color).m_5752_();
                    bufferBuilder.m_5483_((double)(startX + i + 1), (double)(startY + j), 0.0).m_193479_(color).m_5752_();
                    bufferBuilder.m_5483_((double)(startX + i), (double)(startY + j), 0.0).m_193479_(color).m_5752_();
                }
            }
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            for (i = -2; i <= 2; ++i) {
                for (j = -2; j <= 2; ++j) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 || this.selectedX + i < startX || this.selectedX + i > startX + w || this.selectedY + j < startY || this.selectedY + j > startY + h) continue;
                    GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.selectedX + i), (int)(this.selectedY + j), (int)(this.selectedX + i + 1), (int)(this.selectedY + j + 1), (int)-16777216);
                }
            }
            this.m_7906_(pPoseStack, Minecraft.m_91087_(), pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            this.selectedX = (int)pMouseX;
            this.selectedY = (int)pMouseY;
            int startX = this.f_93620_ + 1;
            int startY = this.f_93621_ + 1;
            int w = this.f_93618_ - 2;
            int h = this.f_93619_ - 2;
            int i = this.selectedX - startX;
            int j = this.selectedY - startY;
            Color c = ColorPicker.getColor(w, h, i, j);
            this.selectedColor = c.getAlpha() << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
            ColorButton.selectedEditBox.m_94144_("#" + Integer.toHexString(this.selectedColor).substring(2));
            return true;
        }
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDX, double pDY) {
        if (super.m_7979_(pMouseX, pMouseY, pButton, pDX, pDY)) {
            boolean isInBounds;
            int startX = this.f_93620_ + 1;
            int startY = this.f_93621_ + 1;
            int endX = this.f_93620_ + this.f_93618_ - 1;
            int endY = this.f_93621_ + this.f_93619_ - 1;
            boolean bl = isInBounds = pMouseX >= (double)startX && pMouseX <= (double)endX && pMouseY >= (double)startY && pMouseY <= (double)endY;
            if (isInBounds) {
                this.selectedX = (int)pMouseX;
                this.selectedY = (int)pMouseY;
                int w = this.f_93618_ - 2;
                int h = this.f_93619_ - 2;
                int i = this.selectedX - startX;
                int j = this.selectedY - startY;
                Color c = ColorPicker.getColor(w, h, i, j);
                this.selectedColor = c.getAlpha() << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
                ColorButton.selectedEditBox.m_94144_("#" + Integer.toHexString(this.selectedColor).substring(2));
                return true;
            }
            return false;
        }
        return false;
    }

    public void setSelectedColor(int color) {
        this.selectedColor = color;
        int startX = this.f_93620_ + 1;
        int startY = this.f_93621_ + 1;
        int w = this.f_93618_ - 2;
        int h = this.f_93619_ - 2;
        boolean found = false;
        block0: for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                Color c = ColorPicker.getColor(w, h, i, j);
                int cColor = c.getAlpha() << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
                if (cColor != color) continue;
                this.selectedX = startX + i;
                this.selectedY = startY + j;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            this.selectedX = startX;
            this.selectedY = startY;
        }
    }
}

