/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.proto.CellType;
import com.nodiumhosting.vaultmapper.util.MapRoomIconUtil;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MapComponent
extends GuiComponent
implements Widget {
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int width;
    private final int height;
    private final int centerX;
    private final int centerZ;
    public final List<VaultCell> cells;
    private static final int mapRoomWidth = 16;

    public MapComponent(int x, int y, int width, int height, List<VaultCell> cells) {
        this.x0 = x;
        this.y0 = y;
        this.x1 = x + width;
        this.y1 = y + height;
        this.width = width;
        this.height = height;
        this.centerX = x + width / 2;
        this.centerZ = y + height / 2;
        this.cells = cells;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int x, int y, float partialTicks) {
        boolean showRoomIcons = (Boolean)ClientConfig.SHOW_ROOM_ICONS.get();
        this.cells.forEach(cell -> {
            if (cell.cellType == CellType.CELLTYPE_UNKNOWN) {
                return;
            }
            this.renderCell(poseStack, (VaultCell)cell, showRoomIcons);
        });
    }

    private void renderCell(PoseStack poseStack, VaultCell cell, boolean renderIcon) {
        float endZ;
        float endX;
        float startZ;
        float startX;
        if (cell.cellType == CellType.CELLTYPE_UNKNOWN) {
            return;
        }
        if (cell.inscripted && !cell.explored && !((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get()).booleanValue()) {
            return;
        }
        float mapX = this.centerX + cell.x * 16;
        float mapZ = this.centerZ + cell.z * 16;
        float roomWidth = 8.0f;
        float tunnelLen = 8.0f;
        if (cell.cellType == CellType.CELLTYPE_TUNNEL_X || cell.cellType == CellType.CELLTYPE_TUNNEL_Z) {
            if (cell.cellType == CellType.CELLTYPE_TUNNEL_X) {
                startX = mapX - tunnelLen;
                startZ = mapZ - roomWidth / 2.0f;
                endX = mapX + tunnelLen;
                endZ = mapZ + roomWidth / 2.0f;
            } else {
                startX = mapX - roomWidth / 2.0f;
                startZ = mapZ - tunnelLen;
                endX = mapX + roomWidth / 2.0f;
                endZ = mapZ + tunnelLen;
            }
        } else {
            startX = mapX - roomWidth;
            startZ = mapZ - roomWidth;
            endX = mapX + roomWidth;
            endZ = mapZ + roomWidth;
        }
        float minX = Math.min(startX, endX);
        float maxX = Math.max(startX, endX);
        float minZ = Math.min(startZ, endZ);
        float maxZ = Math.max(startZ, endZ);
        if ((cell.marked || cell.inscripted) && ((Boolean)ClientConfig.SHOW_ROOM_ICONS.get()).booleanValue()) {
            minX -= 8.0f;
            maxX += 8.0f;
            minZ -= 8.0f;
            maxZ += 8.0f;
        }
        int color = MapComponent.parseColor(VaultMap.getCellColor(cell));
        this.m_93179_(poseStack, (int)minX, (int)minZ, (int)maxX, (int)maxZ, color, color);
        if (!renderIcon) {
            return;
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        this.renderCellIcon(poseStack, cell);
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
    }

    private void renderCellIcon(PoseStack poseStack, VaultCell cell) {
        if (cell.roomName == null || cell.roomName.equals("")) {
            cell.roomName = cell.roomType.name();
        }
        ResourceLocation icon = MapRoomIconUtil.getIconForRoom(cell.roomName);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        this.m_93228_(poseStack, this.centerX + cell.x * 16, this.centerZ + cell.z * 16, 0, 0, 16, 16);
    }

    public static int parseColor(String hexColor) {
        try {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

