/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.map.VaultMapOverlayRenderer;
import com.nodiumhosting.vaultmapper.map.snapshots.MapSnapshot;
import com.nodiumhosting.vaultmapper.proto.CellType;
import com.nodiumhosting.vaultmapper.proto.RoomType;
import com.nodiumhosting.vaultmapper.util.MapRoomIconUtil;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class MapContainerElement
extends VerticalScrollClipContainer<MapContainerElement> {
    boolean isDragging;
    double mapCenterX;
    double mapCenterZ;
    double prevMouseX;
    double prevMouseZ;
    double zoomVal = 1.0;

    public MapContainerElement(ISpatial spatial, String fileName) {
        this(spatial, MapSnapshot.from(fileName));
    }

    public MapContainerElement(ISpatial spatial, UUID uuid) {
        this(spatial, MapSnapshot.from(uuid));
    }

    public MapContainerElement(ISpatial spatial, Optional<MapSnapshot> snapshot) {
        super(spatial, Padding.of((int)2, (int)0));
        ((MapElement)this.addElement((IElement)new MapElement((IPosition)Spatials.positionY((int)3), snapshot, this))).postLayout((screen, gui, parent, world) -> {
            world.translateX((this.innerWidth() - world.width()) / 2);
            return true;
        });
    }

    private static boolean shouldRenderCell(VaultCell cell) {
        return !cell.inscripted || cell.explored || (Boolean)ClientConfig.SHOW_INSCRIPTIONS.get() != false;
    }

    private static void renderTextureCell(BufferBuilder bufferBuilder, VaultCell cell, float centerX, float centerZ, float width) {
        float mapX = centerX + (float)cell.x * (width / 2.0f);
        float mapZ = centerZ + (float)cell.z * (width / 2.0f);
        int crop = (Integer)ClientConfig.ICON_CROP.get();
        float scale = (16.0f - (float)(2 * crop)) / 16.0f;
        float halfSize = width * scale / 2.0f;
        float minX = mapX - halfSize;
        float maxX = mapX + halfSize;
        float minZ = mapZ - halfSize;
        float maxZ = mapZ + halfSize;
        float zeroOff = (float)crop / 16.0f;
        float oneOff = 1.0f - (float)crop / 16.0f;
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_7421_(zeroOff, oneOff).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)maxZ, 0.0).m_7421_(oneOff, oneOff).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)minZ, 0.0).m_7421_(oneOff, zeroOff).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZ, 0.0).m_7421_(zeroOff, zeroOff).m_5752_();
    }

    private static void renderCell(BufferBuilder bufferBuilder, VaultCell cell, int color, float centerX, float centerZ, float width) {
        float endZ;
        float endX;
        float startZ;
        float startX;
        float mapX = centerX + (float)cell.x * width;
        float mapZ = centerZ + (float)cell.z * width;
        float coordOffset = width / 2.0f;
        if (cell.cellType == CellType.CELLTYPE_TUNNEL_X || cell.cellType == CellType.CELLTYPE_TUNNEL_Z) {
            if (cell.cellType == CellType.CELLTYPE_TUNNEL_X) {
                startX = mapX - coordOffset;
                startZ = mapZ - coordOffset / 2.0f;
                endX = mapX + coordOffset;
                endZ = mapZ + coordOffset / 2.0f;
            } else {
                startX = mapX - coordOffset / 2.0f;
                startZ = mapZ - coordOffset;
                endX = mapX + coordOffset / 2.0f;
                endZ = mapZ + coordOffset;
            }
        } else {
            startX = mapX - coordOffset;
            startZ = mapZ - coordOffset;
            endX = mapX + coordOffset;
            endZ = mapZ + coordOffset;
        }
        float minX = Math.min(startX, endX);
        float maxX = Math.max(startX, endX);
        float minZ = Math.min(startZ, endZ);
        float maxZ = Math.max(startZ, endZ);
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)minZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZ, 0.0).m_193479_(color).m_5752_();
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.zoomVal += 0.1;
        } else if (delta < 0.0) {
            this.zoomVal -= 0.1;
        }
        if (this.zoomVal <= 0.3) {
            this.zoomVal = 0.3;
        }
        if (this.zoomVal >= 3.0) {
            this.zoomVal = 3.0;
        }
        return super.onMouseScrolled(mouseX, mouseY, delta);
    }

    public void onMouseMoved(double mouseX, double mouseY) {
        if (this.isDragging) {
            this.mapCenterX += mouseX - this.prevMouseX;
            this.mapCenterZ += mouseY - this.prevMouseZ;
        }
        this.prevMouseX = mouseX;
        this.prevMouseZ = mouseY;
        super.onMouseMoved(mouseX, mouseY);
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        this.isDragging = true;
        return super.onMouseClicked(mouseX, mouseY, buttonIndex);
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
        this.isDragging = false;
        return super.onMouseReleased(mouseX, mouseY, buttonIndex);
    }

    private static final class MapElement
    extends ElasticContainerElement<MapElement> {
        List<VaultCell> cells;
        MapContainerElement window;

        private MapElement(IPosition position, UUID uuid, MapContainerElement window) {
            this(position, MapSnapshot.from(uuid), window);
        }

        private MapElement(IPosition position, String fileName, MapContainerElement window) {
            this(position, MapSnapshot.from(fileName), window);
        }

        private MapElement(IPosition position, Optional<MapSnapshot> optMap, MapContainerElement window) {
            super((ISpatial)Spatials.positionXYZ((IPosition)position));
            this.window = window;
            IMutableSpatial spatial = Spatials.positionXYZ((IPosition)position);
            spatial.positionZ(10);
            if (optMap.isEmpty()) {
                this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(0).positionY(5), (Component)new TextComponent("No map save available for this vault"), new LabelTextStyle.Builder()));
                return;
            }
            MapSnapshot map = optMap.get();
            this.cells = map.cells;
            int cellCount = this.cells.stream().filter(cell -> cell.cellType == CellType.CELLTYPE_ROOM && cell.explored).toArray().length;
            int inscriptionCount = this.cells.stream().filter(cell -> cell.inscripted).toArray().length;
            int markedCount = this.cells.stream().filter(cell -> cell.marked).toArray().length;
            int omegaRoomCount = this.cells.stream().filter(cell -> cell.roomType == RoomType.ROOMTYPE_OMEGA).toArray().length;
            int challengeRoomCount = this.cells.stream().filter(cell -> cell.roomType == RoomType.ROOMTYPE_CHALLENGE).toArray().length;
            int oreRoomCount = this.cells.stream().filter(cell -> cell.roomType == RoomType.ROOMTYPE_ORE).toArray().length;
            int resourceRoomCount = this.cells.stream().filter(cell -> cell.roomType == RoomType.ROOMTYPE_RESOURCE).toArray().length;
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(5), (Component)new TextComponent("Explored Rooms: " + cellCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(15), (Component)new TextComponent("Inscription Rooms: " + inscriptionCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(25), (Component)new TextComponent("Marked Rooms: " + markedCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(35), (Component)new TextComponent("Omega Rooms: " + omegaRoomCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(45), (Component)new TextComponent("Challenge Rooms: " + challengeRoomCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(55), (Component)new TextComponent("Ore Rooms: " + oreRoomCount), new LabelTextStyle.Builder()));
            this.addElement((IElement)new LabelElement((IPosition)spatial.positionX(-55).positionY(65), (Component)new TextComponent("Resource Rooms: " + resourceRoomCount), new LabelTextStyle.Builder()));
        }

        public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            if (this.cells == null) {
                return;
            }
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float w = Minecraft.m_91087_().m_91268_().m_85445_();
            float h = Minecraft.m_91087_().m_91268_().m_85446_();
            float windowWidth = this.width();
            float mapRoomWidth = windowWidth / 49.0f * 2.0f * (float)this.window.zoomVal;
            if (((Boolean)ClientConfig.SHOW_TUNNELS.get()).booleanValue()) {
                for (VaultCell vaultCell : this.cells) {
                    if (vaultCell.cellType != CellType.CELLTYPE_TUNNEL_X && vaultCell.cellType != CellType.CELLTYPE_TUNNEL_Z || !MapContainerElement.shouldRenderCell(vaultCell)) continue;
                    MapContainerElement.renderCell(bufferBuilder, vaultCell, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(vaultCell)), (float)((double)(w / 2.0f) + this.window.mapCenterX), (float)(125.0 + this.window.mapCenterZ), mapRoomWidth);
                }
            }
            for (VaultCell vaultCell : this.cells) {
                if (vaultCell.cellType != CellType.CELLTYPE_ROOM || !MapContainerElement.shouldRenderCell(vaultCell)) continue;
                MapContainerElement.renderCell(bufferBuilder, vaultCell, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(vaultCell)), (float)((double)(w / 2.0f) + this.window.mapCenterX), (float)(125.0 + this.window.mapCenterZ), mapRoomWidth);
            }
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            for (VaultCell vaultCell : this.cells) {
                if (vaultCell.cellType != CellType.CELLTYPE_ROOM || !MapContainerElement.shouldRenderCell(vaultCell)) continue;
                if (vaultCell.roomName == null || vaultCell.roomName.equals("")) {
                    vaultCell.roomName = vaultCell.roomType.name();
                }
                ResourceLocation icon = MapRoomIconUtil.getIconForRoom(vaultCell.roomName);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                try {
                    MapContainerElement.renderTextureCell(bufferBuilder, vaultCell, (float)((double)(w / 2.0f) + this.window.mapCenterX), (float)(125.0 + this.window.mapCenterZ), mapRoomWidth * 2.0f);
                }
                catch (Exception e) {
                    VaultMapper.LOGGER.error("Failed to render icon for room: " + vaultCell.roomName);
                }
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            this.cells.stream().filter(cell -> cell.cellType == CellType.CELLTYPE_ROOM && (cell.inscripted || cell.marked)).forEach(cell -> {
                if (cell.inscripted && !cell.explored && !((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get()).booleanValue()) {
                    return;
                }
                float mapX = (float)((double)(w / 2.0f) + this.window.mapCenterX) + (float)cell.x * mapRoomWidth;
                float mapZ = (float)(125.0 + this.window.mapCenterZ) + (float)cell.z * mapRoomWidth;
                int crop = (Integer)ClientConfig.ICON_CROP.get();
                float scale = (16.0f - (float)(2 * crop)) / 16.0f;
                float halfSize = mapRoomWidth * scale;
                float minX = mapX - halfSize;
                float maxX = mapX + halfSize;
                float minZ = mapZ - halfSize;
                float maxZ = mapZ + halfSize;
                VaultMapOverlayRenderer.renderBorder(bufferBuilder, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(cell)), minX, minZ, maxX, maxZ, 0.125f * mapRoomWidth);
            });
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }
    }
}

