/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.gui.component.ColorButton;
import com.nodiumhosting.vaultmapper.gui.component.ColorPicker;
import com.nodiumhosting.vaultmapper.gui.component.EditBoxReset;
import com.nodiumhosting.vaultmapper.gui.component.Slider;
import com.nodiumhosting.vaultmapper.map.VaultMapOverlayRenderer;
import com.nodiumhosting.vaultmapper.util.Clamp;
import com.nodiumhosting.vaultmapper.util.Util;
import it.unimi.dsi.fastutil.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class VaultMapperConfigScreen
extends Screen {
    public VaultMapperConfigScreen() {
        super((Component)new TextComponent("Vault Mapper Config"));
    }

    private static int parseColor(String hexColor) {
        try {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int getScaledY(float y) {
        float height = Minecraft.m_91087_().m_91268_().m_85446_();
        float piece = height / 22.0f;
        float scaledY = piece * y;
        return (int)scaledY;
    }

    protected void m_7856_() {
        super.m_7856_();
        int elHeight = this.getScaledY(1.0f) / 2;
        int elWidth = 200;
        int width = 100;
        int elWidthColor = width - elHeight - 5;
        Button mapEnabledButton = new Button(this.f_96543_ / 2 - 100, this.getScaledY(1.0f), elWidth, Math.min(this.getScaledY(1.0f) / 3 * 2, 20), (Component)new TextComponent("Map Enabled: " + String.valueOf(ClientConfig.MAP_ENABLED.get())), button -> {
            ClientConfig.MAP_ENABLED.set((Object)((Boolean)ClientConfig.MAP_ENABLED.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)new TextComponent("Map Enabled: " + String.valueOf(ClientConfig.MAP_ENABLED.get())));
        });
        this.m_142416_((GuiEventListener)mapEnabledButton);
        Function mapScaleGetter = value -> {
            int valueInt = (Integer)value;
            float floatValue = (float)valueInt / 10.0f;
            String stringValue = floatValue + "x";
            return stringValue;
        };
        Function PCCutoffGetter = value -> {
            int valueInt = (Integer)value;
            return valueInt + " cells";
        };
        Function cropGetter = value -> {
            int valueInt;
            return valueInt + " pixel" + ((valueInt = ((Integer)value).intValue()) != 1 ? "s" : "");
        };
        Slider mapScale = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(2.0f), "", (Integer)ClientConfig.MAP_SCALE.get(), 30.0f, 3.0f, (Function<Float, String>)mapScaleGetter, width, elHeight, 10);
        this.m_142416_((GuiEventListener)mapScale);
        Slider arrowScale = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(3.0f), "", (Integer)ClientConfig.ARROW_SCALE.get(), 30.0f, 3.0f, (Function<Float, String>)mapScaleGetter, width, elHeight, 10);
        this.m_142416_((GuiEventListener)arrowScale);
        Slider PCCutoff = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(4.0f), "", (Integer)ClientConfig.PC_CUTOFF.get(), 30.0f, 4.0f, (Function<Float, String>)PCCutoffGetter, width, elHeight, 20);
        this.m_142416_((GuiEventListener)PCCutoff);
        Slider iconCrop = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(5.0f), "", (Integer)ClientConfig.ICON_CROP.get(), 8.0f, 0.0f, (Function<Float, String>)cropGetter, width, elHeight, 0);
        this.m_142416_((GuiEventListener)iconCrop);
        MutableComponent enabledText = new TextComponent("\u2714").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN});
        MutableComponent disabledText = new TextComponent("\u274c").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
        Button playerCentric = new Button(this.f_96543_ / 2 + width + 15, this.getScaledY(4.0f), elHeight, Math.min(elHeight, 20), (Component)((Boolean)ClientConfig.PLAYER_CENTRIC_RENDERING.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.PLAYER_CENTRIC_RENDERING.set((Object)((Boolean)ClientConfig.PLAYER_CENTRIC_RENDERING.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.PLAYER_CENTRIC_RENDERING.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Player Centric Rendering"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)playerCentric);
        Button enablePCBorderButton = new Button(this.f_96543_ / 2 + width + 15 + 2 + elHeight, this.getScaledY(4.0f), elHeight, Math.min(elHeight, 20), (Component)((Boolean)ClientConfig.PC_BORDER.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.PC_BORDER.set((Object)((Boolean)ClientConfig.PC_BORDER.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.PC_BORDER.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Player Centric Border"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)enablePCBorderButton);
        EditBoxReset mapXOffset = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(6.0f), width, elHeight, (Component)new TextComponent("MAP_X_OFFSET"), "0");
        mapXOffset.m_94144_(((Integer)ClientConfig.MAP_X_OFFSET.get()).toString());
        this.m_142416_((GuiEventListener)mapXOffset);
        EditBoxReset mapYOffset = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(7.0f), width, elHeight, (Component)new TextComponent("MAP_Y_OFFSET"), "0");
        mapYOffset.m_94144_(((Integer)ClientConfig.MAP_Y_OFFSET.get()).toString());
        this.m_142416_((GuiEventListener)mapYOffset);
        Function anchorGetterX = value -> {
            switch ((Integer)value) {
                case 0: {
                    return "Left";
                }
                case 1: {
                    return "Left Center";
                }
                case 2: {
                    return "Center";
                }
                case 3: {
                    return "Right Center";
                }
                case 4: {
                    return "Right";
                }
            }
            return "Unknown";
        };
        Slider mapXAnchor = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(8.0f), "", (Integer)ClientConfig.MAP_X_ANCHOR.get(), 4.0f, 0.0f, (Function<Float, String>)anchorGetterX, width, elHeight, 4);
        this.m_142416_((GuiEventListener)mapXAnchor);
        Function anchorGetterY = value -> {
            switch ((Integer)value) {
                case 0: {
                    return "Top";
                }
                case 1: {
                    return "Top Center";
                }
                case 2: {
                    return "Center";
                }
                case 3: {
                    return "Bottom Center";
                }
                case 4: {
                    return "Bottom";
                }
            }
            return "Unknown";
        };
        Slider mapYAnchor = new Slider(this.f_96543_ / 2 + 10, this.getScaledY(9.0f), "", (Integer)ClientConfig.MAP_Y_ANCHOR.get(), 4.0f, 0.0f, (Function<Float, String>)anchorGetterY, width, elHeight, 4);
        this.m_142416_((GuiEventListener)mapYAnchor);
        ColorPicker colorPicker = new ColorPicker(Clamp.clamp(this.f_96543_ / 2 + 200, 0, this.f_96543_ - 200), this.getScaledY(7.0f), 200, 200, VaultMapperConfigScreen.parseColor("#000000"), button -> {});
        colorPicker.f_93624_ = false;
        this.m_142416_((GuiEventListener)colorPicker);
        EditBoxReset pointerColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(10.0f), elWidthColor, elHeight, (Component)new TextComponent("POINTER_COLOR"), "#00FF00");
        pointerColor.m_94144_((String)ClientConfig.POINTER_COLOR.get());
        this.m_142416_((GuiEventListener)pointerColor);
        ColorButton pointerColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(10.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.POINTER_COLOR.get()), button -> {}, pointerColor, colorPicker);
        this.m_142416_((GuiEventListener)pointerColorPicker);
        pointerColor.m_94151_(value -> pointerColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset roomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(11.0f), elWidthColor, elHeight, (Component)new TextComponent("ROOM_COLOR"), "#0000FF");
        roomColor.m_94144_((String)ClientConfig.ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)roomColor);
        ColorButton roomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(11.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.ROOM_COLOR.get()), button -> {}, roomColor, colorPicker);
        this.m_142416_((GuiEventListener)roomColorPicker);
        roomColor.m_94151_(value -> roomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        Button showTunnels = new Button(this.f_96543_ / 2 + elWidthColor + 5 + 10 + elHeight + 5, this.getScaledY(11.0f), elHeight, Math.min(elHeight, 20), (Component)((Boolean)ClientConfig.SHOW_TUNNELS.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.SHOW_TUNNELS.set((Object)((Boolean)ClientConfig.SHOW_TUNNELS.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.SHOW_TUNNELS.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Show Tunnels"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)showTunnels);
        EditBoxReset startRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(12.0f), elWidthColor, elHeight, (Component)new TextComponent("START_ROOM_COLOR"), "#FF0000");
        startRoomColor.m_94144_((String)ClientConfig.START_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)startRoomColor);
        ColorButton startRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(12.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.START_ROOM_COLOR.get()), button -> {}, startRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)startRoomColorPicker);
        startRoomColor.m_94151_(value -> startRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset markedRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(13.0f), elWidthColor, elHeight, (Component)new TextComponent("MARKED_ROOM_COLOR"), "#FF00FF");
        markedRoomColor.m_94144_((String)ClientConfig.MARKED_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)markedRoomColor);
        ColorButton markedRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(13.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.MARKED_ROOM_COLOR.get()), button -> {}, markedRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)markedRoomColorPicker);
        markedRoomColor.m_94151_(value -> markedRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset inscriptionRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(14.0f), elWidthColor, elHeight, (Component)new TextComponent("INSCRIPTION_ROOM_COLOR"), "#FFFF00");
        inscriptionRoomColor.m_94144_((String)ClientConfig.INSCRIPTION_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)inscriptionRoomColor);
        ColorButton inscriptionRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(14.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.INSCRIPTION_ROOM_COLOR.get()), button -> {}, inscriptionRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)inscriptionRoomColorPicker);
        inscriptionRoomColor.m_94151_(value -> inscriptionRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        Button showInscription = new Button(this.f_96543_ / 2 + elWidthColor + 5 + 10 + elHeight + 5, this.getScaledY(14.0f), elHeight, Math.min(elHeight, 20), (Component)((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.SHOW_INSCRIPTIONS.set((Object)((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Show Inscriptions"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)showInscription);
        EditBoxReset omegaRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(15.0f), elWidthColor, elHeight, (Component)new TextComponent("OMEGA_ROOM_COLOR"), "#55FF55");
        omegaRoomColor.m_94144_((String)ClientConfig.OMEGA_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)omegaRoomColor);
        ColorButton omegaRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(15.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.OMEGA_ROOM_COLOR.get()), button -> {}, omegaRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)omegaRoomColorPicker);
        omegaRoomColor.m_94151_(value -> omegaRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset challengeRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(16.0f), elWidthColor, elHeight, (Component)new TextComponent("CHALLENGE_ROOM_COLOR"), "#F09E00");
        challengeRoomColor.m_94144_((String)ClientConfig.CHALLENGE_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)challengeRoomColor);
        ColorButton challengeRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(16.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.CHALLENGE_ROOM_COLOR.get()), button -> {}, challengeRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)challengeRoomColorPicker);
        challengeRoomColor.m_94151_(value -> challengeRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset oreRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(17.0f), elWidthColor, elHeight, (Component)new TextComponent("ORE_ROOM_COLOR"), "#00FFFF");
        oreRoomColor.m_94144_((String)ClientConfig.ORE_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)oreRoomColor);
        ColorButton oreRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(17.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.ORE_ROOM_COLOR.get()), button -> {}, oreRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)oreRoomColorPicker);
        oreRoomColor.m_94151_(value -> oreRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        EditBoxReset resourceRoomColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(18.0f), elWidthColor, elHeight, (Component)new TextComponent("RESOURCE_ROOM_COLOR"), "#FFFFFF");
        resourceRoomColor.m_94144_((String)ClientConfig.RESOURCE_ROOM_COLOR.get());
        this.m_142416_((GuiEventListener)resourceRoomColor);
        ColorButton resourceRoomColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(18.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.RESOURCE_ROOM_COLOR.get()), button -> {}, resourceRoomColor, colorPicker);
        this.m_142416_((GuiEventListener)resourceRoomColorPicker);
        resourceRoomColor.m_94151_(value -> resourceRoomColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        Button showRoomIcons = new Button(this.f_96543_ / 2 + elWidthColor + 5 + 10 + elHeight + 5, this.getScaledY(16.5f), elHeight, Math.min(elHeight, 20), (Component)((Boolean)ClientConfig.SHOW_ROOM_ICONS.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.SHOW_ROOM_ICONS.set((Object)((Boolean)ClientConfig.SHOW_ROOM_ICONS.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.SHOW_ROOM_ICONS.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Show Room Icons"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)showRoomIcons);
        EditBoxReset syncServer = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 - 70, this.getScaledY(19.0f), elWidthColor + 80, elHeight, (Component)new TextComponent("SYNC_SERVER"), "wss://vmsync.ndmh.xyz");
        syncServer.m_94144_((String)ClientConfig.VMSYNC_SERVER.get());
        this.m_142416_((GuiEventListener)syncServer);
        Button enableSyncButton = new Button(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(19.0f), elHeight, elHeight, (Component)((Boolean)ClientConfig.SYNC_ENABLED.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.SYNC_ENABLED.set((Object)((Boolean)ClientConfig.SYNC_ENABLED.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.SYNC_ENABLED.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Sync"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)enableSyncButton);
        Button showViewerCodeButton = new Button(this.f_96543_ / 2 + elWidthColor + 5 + 10 + elHeight + 5, this.getScaledY(19.0f), elHeight, elHeight, (Component)((Boolean)ClientConfig.SHOW_VIEWER_CODE.get() != false ? enabledText : disabledText), button -> {
            ClientConfig.SHOW_VIEWER_CODE.set((Object)((Boolean)ClientConfig.SHOW_VIEWER_CODE.get() == false ? 1 : 0));
            ClientConfig.SPEC.save();
            button.m_93666_((Component)((Boolean)ClientConfig.SHOW_VIEWER_CODE.get() != false ? enabledText : disabledText));
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96602_(pPoseStack, (Component)new TextComponent("Show Viewer Code"), pMouseX, pMouseY));
        this.m_142416_((GuiEventListener)showViewerCodeButton);
        EditBoxReset syncColor = new EditBoxReset(this.f_96547_, this.f_96543_ / 2 + 10, this.getScaledY(20.0f), elWidthColor, elHeight, (Component)new TextComponent("SYNC_COLOR"), Util.RandomColor());
        syncColor.m_94144_((String)ClientConfig.SYNC_COLOR.get());
        this.m_142416_((GuiEventListener)syncColor);
        ColorButton syncColorPicker = new ColorButton(this.f_96543_ / 2 + elWidthColor + 5 + 10, this.getScaledY(20.0f), elHeight, elHeight, VaultMapperConfigScreen.parseColor((String)ClientConfig.SYNC_COLOR.get()), button -> {}, syncColor, colorPicker);
        this.m_142416_((GuiEventListener)syncColorPicker);
        syncColor.m_94151_(value -> syncColorPicker.setColor(VaultMapperConfigScreen.parseColor(value)));
        Button saveButton = new Button(this.f_96543_ - 100 - 5, this.f_96544_ - 20 - 5, 100, 20, (Component)new TextComponent("Save"), button -> {
            try {
                ClientConfig.MAP_X_OFFSET.set((Object)Integer.parseInt(mapXOffset.m_94155_()));
            }
            catch (NumberFormatException e) {
                mapXOffset.m_94144_("0");
                ClientConfig.MAP_X_OFFSET.set((Object)0);
            }
            try {
                ClientConfig.MAP_Y_OFFSET.set((Object)Integer.parseInt(mapYOffset.m_94155_()));
            }
            catch (NumberFormatException e) {
                mapYOffset.m_94144_("0");
                ClientConfig.MAP_Y_OFFSET.set((Object)0);
            }
            ClientConfig.MAP_SCALE.set((Object)mapScale.sliderValue);
            ClientConfig.ARROW_SCALE.set((Object)arrowScale.sliderValue);
            ClientConfig.MAP_X_ANCHOR.set((Object)mapXAnchor.sliderValue);
            ClientConfig.MAP_Y_ANCHOR.set((Object)mapYAnchor.sliderValue);
            ClientConfig.POINTER_COLOR.set((Object)pointerColor.m_94155_());
            ClientConfig.ROOM_COLOR.set((Object)roomColor.m_94155_());
            ClientConfig.START_ROOM_COLOR.set((Object)startRoomColor.m_94155_());
            ClientConfig.MARKED_ROOM_COLOR.set((Object)markedRoomColor.m_94155_());
            ClientConfig.INSCRIPTION_ROOM_COLOR.set((Object)inscriptionRoomColor.m_94155_());
            ClientConfig.OMEGA_ROOM_COLOR.set((Object)omegaRoomColor.m_94155_());
            ClientConfig.CHALLENGE_ROOM_COLOR.set((Object)challengeRoomColor.m_94155_());
            ClientConfig.ORE_ROOM_COLOR.set((Object)oreRoomColor.m_94155_());
            ClientConfig.RESOURCE_ROOM_COLOR.set((Object)resourceRoomColor.m_94155_());
            ClientConfig.VMSYNC_SERVER.set((Object)syncServer.m_94155_());
            ClientConfig.SYNC_COLOR.set((Object)syncColor.m_94155_());
            ClientConfig.PC_CUTOFF.set((Object)PCCutoff.sliderValue);
            ClientConfig.ICON_CROP.set((Object)iconCrop.sliderValue);
            ClientConfig.SPEC.save();
            VaultMapOverlayRenderer.prep();
        });
        this.m_142416_((GuiEventListener)saveButton);
        Button resetButton = new Button(5, this.f_96544_ - 20 - 5, 100, 20, (Component)new TextComponent("Reset"), button -> {
            mapScale.sliderValue = 10;
            arrowScale.sliderValue = 10;
            mapXOffset.m_94144_("0");
            mapYOffset.m_94144_("0");
            mapXAnchor.sliderValue = 4;
            mapYAnchor.sliderValue = 4;
            pointerColor.m_94144_("#00FF00");
            roomColor.m_94144_("#0000FF");
            startRoomColor.m_94144_("#FF0000");
            markedRoomColor.m_94144_("#FF00FF");
            inscriptionRoomColor.m_94144_("#FFFF00");
            showRoomIcons.m_93666_((Component)enabledText);
            omegaRoomColor.m_94144_("#55FF55");
            challengeRoomColor.m_94144_("#F09E00");
            oreRoomColor.m_94144_("#00FFFF");
            resourceRoomColor.m_94144_("#FFFFFF");
            showInscription.m_93666_((Component)enabledText);
            syncServer.m_94144_("wss://vmsync.ndmh.xyz");
            enableSyncButton.m_93666_((Component)enabledText);
            showViewerCodeButton.m_93666_((Component)disabledText);
            String randColor = Util.RandomColor();
            syncColor.m_94144_(randColor);
            PCCutoff.sliderValue = 20;
            playerCentric.m_93666_((Component)disabledText);
            enablePCBorderButton.m_93666_((Component)enabledText);
            iconCrop.sliderValue = 0;
            ClientConfig.MAP_SCALE.set((Object)10);
            ClientConfig.ARROW_SCALE.set((Object)10);
            ClientConfig.MAP_X_OFFSET.set((Object)0);
            ClientConfig.MAP_Y_OFFSET.set((Object)0);
            ClientConfig.MAP_X_ANCHOR.set((Object)4);
            ClientConfig.MAP_Y_ANCHOR.set((Object)4);
            ClientConfig.POINTER_COLOR.set((Object)"#00FF00");
            ClientConfig.ROOM_COLOR.set((Object)"#0000FF");
            ClientConfig.START_ROOM_COLOR.set((Object)"#FF0000");
            ClientConfig.MARKED_ROOM_COLOR.set((Object)"#FF00FF");
            ClientConfig.INSCRIPTION_ROOM_COLOR.set((Object)"#FFFF00");
            ClientConfig.SHOW_INSCRIPTIONS.set((Object)true);
            ClientConfig.OMEGA_ROOM_COLOR.set((Object)"#55FF55");
            ClientConfig.CHALLENGE_ROOM_COLOR.set((Object)"#F09E00");
            ClientConfig.ORE_ROOM_COLOR.set((Object)"#00FFFF");
            ClientConfig.RESOURCE_ROOM_COLOR.set((Object)"#FFFFFF");
            ClientConfig.SHOW_ROOM_ICONS.set((Object)true);
            ClientConfig.VMSYNC_SERVER.set((Object)"wss://vmsync.ndmh.xyz");
            ClientConfig.SYNC_ENABLED.set((Object)true);
            ClientConfig.SYNC_COLOR.set((Object)randColor);
            ClientConfig.SHOW_VIEWER_CODE.set((Object)false);
            ClientConfig.PC_CUTOFF.set((Object)20);
            ClientConfig.PLAYER_CENTRIC_RENDERING.set((Object)false);
            ClientConfig.PC_BORDER.set((Object)true);
            ClientConfig.SPEC.save();
            VaultMapOverlayRenderer.onWindowResize();
        });
        this.m_142416_((GuiEventListener)resetButton);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(pose);
        this.f_96547_.m_92883_(pose, "Vault Mapper v" + VaultMapper.getVersion(), 8.0f, 8.0f, -1);
        this.f_96547_.m_92883_(pose, "Vault Mapper Config", (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_("Vault Mapper Config") / 2), 10.0f, -1);
        int offsetY = this.getScaledY(1.0f) / 8;
        this.f_96547_.m_92883_(pose, "Map Scale", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(2.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Arrow Scale", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(3.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Player Centric Cutoff", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(4.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Icon Crop", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(5.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Map X Offset", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(6.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Map Y Offset", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(7.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Map X Anchor", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(8.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Map Y Anchor", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(9.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Pointer Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(10.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(11.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Start Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(12.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Marked Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(13.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Inscription Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(14.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Omega Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(15.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Challenge Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(16.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Ore Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(17.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Resource Room Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(18.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "VMSync", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(19.0f) + offsetY), -1);
        this.f_96547_.m_92883_(pose, "Sync Color", (float)(this.f_96543_ / 2 - 110), (float)(this.getScaledY(20.0f) + offsetY), -1);
        super.m_6305_(pose, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ColorButton.clearListeners();
    }

    public void m_7861_() {
        super.m_7861_();
        ColorButton.clearListeners();
    }
}

