/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.map;

import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMapOverlayRenderer;
import com.nodiumhosting.vaultmapper.map.snapshots.MapCache;
import com.nodiumhosting.vaultmapper.network.sync.SyncClient;
import com.nodiumhosting.vaultmapper.proto.CellType;
import com.nodiumhosting.vaultmapper.proto.RoomType;
import com.nodiumhosting.vaultmapper.util.CellCoordinate;
import iskallia.vault.core.data.key.GenericFieldKey;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VaultMap {
    public static String viewerCode = "";
    public static boolean enabled;
    public static boolean debug;
    public static SyncClient syncClient;
    public static ConcurrentHashMap<String, MapPlayer> players;
    public static CopyOnWriteArrayList<VaultCell> cells;
    public static ConcurrentHashMap<CellCoordinate, VaultCell> cellCache;
    static VaultCell startRoom;
    static VaultCell currentRoom;
    static int defaultMapSize;
    static int northSize;
    static int eastSize;
    static int southSize;
    static int westSize;
    static CompoundTag hologramData;
    static boolean hologramChecked;
    private static int discoveredRoomSizeCache;
    private static int clientTickCount;
    private static float oldYaw;
    private static int oldRoomX;
    private static int oldRoomZ;

    public static void updatePlayerMapData(String uuid, String color, int x, int y, float yaw) {
        if (!players.containsKey(uuid) && !uuid.equals(Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_20149_())) {
            players.put(uuid, new MapPlayer());
        }
        MapPlayer player = players.get(uuid);
        player.uuid = uuid;
        player.color = color;
        player.x = x;
        player.y = y;
        player.yaw = yaw;
    }

    public static void removePlayerMapData(String uuid) {
        players.remove(uuid);
    }

    public static void clearPlayers() {
        players.clear();
    }

    public static void startSync(String playerUUID, String dimName) {
        if (!((Boolean)ClientConfig.SYNC_ENABLED.get()).booleanValue()) {
            return;
        }
        if (syncClient != null) {
            VaultMap.clearPlayers();
            syncClient.closeGracefully();
            syncClient = null;
        }
        viewerCode = "";
        syncClient = new SyncClient(playerUUID, dimName);
        syncClient.connect();
        for (VaultCell cell : cellCache.values()) {
            syncClient.sendCellPacket(cell);
        }
    }

    public static void stopSync() {
        if (syncClient != null) {
            VaultMap.clearPlayers();
            syncClient.closeGracefully();
            syncClient = null;
        }
    }

    public static List<VaultCell> getCells() {
        return cells;
    }

    public static void refreshCache() {
        cellCache.clear();
        for (VaultCell cell : cells) {
            cellCache.put(new CellCoordinate(cell.x, cell.z), cell);
        }
    }

    public static void resetMap() {
        cells = new CopyOnWriteArrayList();
        cellCache = new ConcurrentHashMap();
        startRoom = new VaultCell(0, 0, CellType.CELLTYPE_ROOM, RoomType.ROOMTYPE_START);
        currentRoom = null;
        hologramChecked = false;
        hologramData = null;
        northSize = defaultMapSize;
        eastSize = defaultMapSize;
        southSize = defaultMapSize;
        westSize = defaultMapSize;
    }

    public static VaultCell getCurrentCell() {
        return currentRoom;
    }

    private static boolean isCurrentRoom(CellCoordinate coord) {
        return currentRoom != null && VaultMap.currentRoom.x == coord.x() && VaultMap.currentRoom.z == coord.z();
    }

    private static CellType getCellType(int x, int z) {
        boolean wBed;
        if (x == 0 && z == 0) {
            return CellType.CELLTYPE_ROOM;
        }
        Block n = VaultMap.getCellBlock(x, z, 23, 33, 42);
        Block e = VaultMap.getCellBlock(x, z, 42, 33, 23);
        Block s = VaultMap.getCellBlock(x, z, 23, 33, 4);
        Block w = VaultMap.getCellBlock(x, z, 4, 33, 23);
        if (n == null || e == null || s == null || w == null) {
            return null;
        }
        boolean nBed = n == ModBlocks.VAULT_BEDROCK;
        boolean eBed = e == ModBlocks.VAULT_BEDROCK;
        boolean sBed = s == ModBlocks.VAULT_BEDROCK;
        boolean bl = wBed = w == ModBlocks.VAULT_BEDROCK;
        if (nBed && eBed && sBed && wBed) {
            return CellType.CELLTYPE_UNKNOWN;
        }
        if (nBed && !eBed && sBed && !wBed) {
            return CellType.CELLTYPE_TUNNEL_X;
        }
        if (!nBed && eBed && !sBed && wBed) {
            return CellType.CELLTYPE_TUNNEL_Z;
        }
        if (!(nBed || eBed || sBed || wBed)) {
            return CellType.CELLTYPE_ROOM;
        }
        return null;
    }

    public static String getCellColor(VaultCell cell) {
        if (cell.roomType == RoomType.ROOMTYPE_START) {
            return (String)ClientConfig.START_ROOM_COLOR.get();
        }
        if (cell.marked) {
            return (String)ClientConfig.MARKED_ROOM_COLOR.get();
        }
        if (cell.inscripted) {
            return (String)ClientConfig.INSCRIPTION_ROOM_COLOR.get();
        }
        if (cell.roomType == RoomType.ROOMTYPE_OMEGA) {
            return (String)ClientConfig.OMEGA_ROOM_COLOR.get();
        }
        if (cell.roomType == RoomType.ROOMTYPE_CHALLENGE) {
            return (String)ClientConfig.CHALLENGE_ROOM_COLOR.get();
        }
        if (cell.roomType == RoomType.ROOMTYPE_ORE) {
            return (String)ClientConfig.ORE_ROOM_COLOR.get();
        }
        if (cell.roomType == RoomType.ROOMTYPE_RESOURCE) {
            return (String)ClientConfig.RESOURCE_ROOM_COLOR.get();
        }
        return (String)ClientConfig.ROOM_COLOR.get();
    }

    public static void addOrReplaceCell(VaultCell cell) {
        VaultCell old = cellCache.put(new CellCoordinate(cell.x, cell.z), cell);
        cells.remove(old);
        cells.add(cell);
        if (cell.x > eastSize) {
            eastSize = cell.x;
        }
        if (cell.x < 0 && Math.abs(cell.x) > westSize) {
            westSize = Math.abs(cell.x);
        }
        if (cell.z > southSize) {
            southSize = cell.z;
        }
        if (cell.z < 0 && Math.abs(cell.z) > northSize) {
            northSize = Math.abs(cell.z);
        }
        VaultMapOverlayRenderer.updateAnchor();
    }

    private static void updateMap() {
        int playerY;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int playerRoomX = (int)Math.floor(player.m_20185_() / 47.0);
        int playerRoomZ = (int)Math.floor(player.m_20189_() / 47.0);
        BlockPos pos = new BlockPos(playerRoomX, 0, playerRoomZ);
        CellCoordinate coord = new CellCoordinate(playerRoomX, playerRoomZ);
        int playerRelativeX = (int)Math.abs(Math.floor(player.m_20185_() % 47.0));
        int playerRelativeZ = (int)Math.abs(Math.floor(player.m_20189_() % 47.0));
        CellType cellType = VaultMap.getCellType(playerRoomX, playerRoomZ);
        if (cellType == null) {
            return;
        }
        if (!(cellType != CellType.CELLTYPE_ROOM || playerRoomX == 0 && playerRoomZ == 0 || cellCache.containsKey(coord))) {
            DiscoveredRoomStat discovered;
            StatsCollector stats = (StatsCollector)ClientVaults.ACTIVE.get((GenericFieldKey)Vault.STATS);
            StatCollector stat = stats == null ? null : stats.get(player.m_142081_());
            DiscoveredRoomStat discoveredRoomStat = discovered = stat == null ? null : (DiscoveredRoomStat)stat.get((GenericFieldKey)StatCollector.ROOMS_DISCOVERED);
            if (discovered == null || discovered.get((Object)pos) == null) {
                return;
            }
        }
        if (!((playerY = (int)player.m_20186_()) >= 27 && playerY <= 37 || cellType != CellType.CELLTYPE_TUNNEL_X && cellType != CellType.CELLTYPE_TUNNEL_Z)) {
            return;
        }
        if (cellType == CellType.CELLTYPE_TUNNEL_X && (playerRelativeZ < 18 || playerRelativeZ > 28)) {
            return;
        }
        if (cellType == CellType.CELLTYPE_TUNNEL_Z && (playerRelativeX < 18 || playerRelativeX > 28)) {
            return;
        }
        VaultMap.syncNewCell(coord, cellType, (Player)player, true);
        MapCache.updateCache();
    }

    public static void syncNewCell(CellCoordinate coordinate, CellType cellType, Player player, boolean setCurrent) {
        VaultCell newCell = cellCache.get(coordinate);
        if (newCell == null) {
            newCell = new VaultCell(coordinate.x(), coordinate.z(), cellType, RoomType.ROOMTYPE_BASIC);
        }
        if (setCurrent) {
            currentRoom = newCell;
        }
        VaultMap.inferRoomTypeForCell(coordinate, newCell, player);
        if (syncClient != null) {
            syncClient.sendCellPacket(newCell);
        }
        VaultMap.addOrReplaceCell(newCell);
    }

    public static void inferRoomTypeForCell(CellCoordinate coordinate, VaultCell cell, Player player) {
        if (coordinate.x() == 0 && coordinate.z() == 0) {
            cell.roomType = RoomType.ROOMTYPE_START;
        } else if (cell.cellType == CellType.CELLTYPE_ROOM && !cellCache.containsKey(coordinate)) {
            cell.roomName = ((ResourceLocation)((DiscoveredRoomStat)((StatsCollector)ClientVaults.ACTIVE.get((GenericFieldKey)Vault.STATS)).get(player.m_142081_()).get((GenericFieldKey)StatCollector.ROOMS_DISCOVERED)).get((Object)new BlockPos(coordinate.x(), 0, coordinate.z()))).toString();
            if (cell.roomName.contains("omega")) {
                cell.roomType = RoomType.ROOMTYPE_OMEGA;
            } else if (cell.roomName.contains("challenge")) {
                cell.roomType = RoomType.ROOMTYPE_CHALLENGE;
            } else if (cell.roomName.contains("raw")) {
                cell.roomType = RoomType.ROOMTYPE_RESOURCE;
            } else if (cell.roomName.contains("/ore")) {
                cell.roomType = RoomType.ROOMTYPE_ORE;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void updateMapFromDiscoveryData(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && ++clientTickCount % 20 == 0) {
            DiscoveredRoomStat discovered;
            clientTickCount = 0;
            StatsCollector stats = (StatsCollector)ClientVaults.ACTIVE.get((GenericFieldKey)Vault.STATS);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            StatCollector stat = stats == null ? null : stats.get(Minecraft.m_91087_().f_91074_.m_142081_());
            DiscoveredRoomStat discoveredRoomStat = discovered = stat == null ? null : (DiscoveredRoomStat)stat.get((GenericFieldKey)StatCollector.ROOMS_DISCOVERED);
            if (discovered != null && discoveredRoomSizeCache != discovered.size()) {
                discoveredRoomSizeCache = discovered.size();
                discovered.forEach((blockPos, resourceLocation) -> {
                    CellCoordinate coordinate = new CellCoordinate(blockPos.m_123341_(), blockPos.m_123343_());
                    if (!cellCache.containsKey(coordinate)) {
                        VaultMap.syncNewCell(coordinate, CellType.CELLTYPE_ROOM, (Player)player, false);
                    }
                });
                MapCache.updateCache();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(MovementInputUpdateEvent event) {
        if (!enabled) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!hologramChecked && player.f_19853_.m_46749_(player.m_20097_()) && hologramData == null && player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault")) {
            hologramData = VaultMap.getHologramData();
            hologramChecked = true;
        }
        int playerRoomX = (int)Math.floor(player.m_20185_() / 47.0);
        int playerRoomZ = (int)Math.floor(player.m_20189_() / 47.0);
        CellCoordinate coord = new CellCoordinate(playerRoomX, playerRoomZ);
        float yaw = player.m_6080_();
        String uuid = player.m_142081_().toString();
        if (syncClient != null) {
            syncClient.sendMovePacket(uuid, playerRoomX, playerRoomZ, yaw);
        }
        if (debug) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)new TextComponent("Current room: " + playerRoomX + ", " + playerRoomZ + " Hologram: " + (hologramData != null ? "Found" : "Not found") + (hologramChecked ? " (Checked)" : "(Not checked)") + " Vault Map Data Size: " + cells.size() + " (" + cells.stream().filter(cell -> cell.cellType == CellType.CELLTYPE_ROOM && cell.explored).count() + " Explored Rooms) + PC: " + String.valueOf(ClientConfig.PLAYER_CENTRIC_RENDERING.get()) + " " + String.valueOf(ClientConfig.PC_CUTOFF.get()) + " (config) / " + VaultMapOverlayRenderer.playerCentricRender + " " + VaultMapOverlayRenderer.cutoff + " (ram)"), false);
        }
        if (!VaultMap.isCurrentRoom(coord)) {
            VaultMap.updateMap();
        }
        if (oldYaw != yaw || playerRoomX != oldRoomX || playerRoomZ != oldRoomZ) {
            oldYaw = yaw;
            oldRoomX = playerRoomX;
            oldRoomZ = playerRoomZ;
        }
    }

    public static void markCurrentCell() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault") || !VaultMapper.isVaultDimension(player.m_183503_().m_46472_().m_135782_().m_135815_())) {
            player.m_6352_((Component)new TextComponent("You can't use this outside of Vaults"), player.m_142081_());
            return;
        }
        VaultMapper.LOGGER.info("Marking room");
        if (currentRoom == null) {
            player.m_6352_((Component)new TextComponent("No rooms available in map"), player.m_142081_());
            return;
        }
        if (VaultMap.currentRoom.x == 0 && VaultMap.currentRoom.z == 0) {
            player.m_6352_((Component)new TextComponent("You can't mark the start room"), player.m_142081_());
            return;
        }
        if (VaultMap.getCellType(VaultMap.currentRoom.x, VaultMap.currentRoom.z) == CellType.CELLTYPE_ROOM) {
            boolean marked = currentRoom.switchMarked();
            if (marked) {
                player.m_6352_((Component)new TextComponent("Room marked"), player.m_142081_());
            } else {
                player.m_6352_((Component)new TextComponent("Room unmarked"), player.m_142081_());
            }
        } else {
            player.m_6352_((Component)new TextComponent("You can only mark rooms"), player.m_142081_());
        }
        if (syncClient != null) {
            syncClient.sendCellPacket(currentRoom);
        }
    }

    public static void toggleRendering() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault") || !VaultMapper.isVaultDimension(player.m_183503_().m_46472_().m_135782_().m_135815_())) {
            player.m_6352_((Component)new TextComponent("You can't use this outside of Vaults"), player.m_142081_());
            return;
        }
        if (((Boolean)ClientConfig.MAP_ENABLED.get()).booleanValue()) {
            ClientConfig.MAP_ENABLED.set((Object)false);
            player.m_6352_((Component)new TextComponent("Vault Map rendering disabled"), player.m_142081_());
        } else {
            ClientConfig.MAP_ENABLED.set((Object)true);
            player.m_6352_((Component)new TextComponent("Vault Map rendering enabled"), player.m_142081_());
        }
        ClientConfig.SPEC.save();
    }

    private static CompoundTag getHologramData() {
        HashMap<BlockPos, Direction> hologramBlocks = new HashMap<BlockPos, Direction>();
        hologramBlocks.put(new BlockPos(23, 27, 13), Direction.NORTH);
        hologramBlocks.put(new BlockPos(33, 27, 23), Direction.EAST);
        hologramBlocks.put(new BlockPos(13, 27, 23), Direction.WEST);
        hologramBlocks.put(new BlockPos(23, 27, 33), Direction.SOUTH);
        CompoundTag hologramNbt = null;
        for (Map.Entry entry : hologramBlocks.entrySet()) {
            CompoundTag hologramData;
            BlockPos hologramBlockPos = (BlockPos)entry.getKey();
            Direction direction = (Direction)entry.getValue();
            BlockState hologramBlockState = Objects.requireNonNull(Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_183503_()).m_8055_(hologramBlockPos);
            if (!Objects.equals(hologramBlockState.m_60734_().getRegistryName(), new ResourceLocation("the_vault:hologram"))) continue;
            BlockEntity hologramBlock = Objects.requireNonNull(Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_183503_()).m_7702_(hologramBlockPos);
            hologramNbt = hologramData = Objects.requireNonNull(hologramBlock).serializeNBT();
        }
        if (hologramNbt == null) {
            return null;
        }
        Tag children = hologramNbt.m_128469_("tree").m_128423_("children");
        ListTag childrenList = (ListTag)children;
        childrenList.forEach(tag -> {
            CompoundTag compound = (CompoundTag)tag;
            CompoundTag stack = compound.m_128469_("stack");
            String id = stack.m_128461_("id");
            int model = stack.m_128469_("tag").m_128469_("data").m_128451_("model");
            Tuple<RoomType, String> room = VaultMap.roomFromModel(model);
            CompoundTag translation = compound.m_128469_("translation");
            byte translationX = translation.m_128445_("x");
            byte translationY = translation.m_128445_("y");
            byte translationXInt = translationX;
            byte translationYInt = translationY;
            VaultCell newCell = new VaultCell(translationXInt * 2, translationYInt * -2, CellType.CELLTYPE_ROOM, (RoomType)((Object)((Object)room.m_14418_())));
            newCell.roomName = (String)room.m_14419_();
            newCell.inscripted = true;
            cells.add(newCell);
            if (syncClient != null) {
                syncClient.sendCellPacket(newCell);
            }
        });
        return hologramNbt;
    }

    public static Block getCellBlock(int cellX, int cellZ, int blockX, int blockY, int blockZ) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        if (!player.m_183503_().m_46472_().m_135782_().m_135827_().equals("the_vault")) {
            return null;
        }
        int xCoord = cellX * 47 + blockX;
        int zCoord = cellZ * 47 + blockZ;
        if (!player.f_19853_.m_46749_(new BlockPos(xCoord, blockY, zCoord))) {
            return null;
        }
        return player.f_19853_.m_8055_(new BlockPos(xCoord, blockY, zCoord)).m_60734_();
    }

    public static Tuple<RoomType, String> roomFromModel(int model) {
        ResourceLocation room = null;
        for (Map.Entry entry : ModConfigs.INSCRIPTION.poolToModel.entrySet()) {
            if ((Integer)entry.getValue() != model) continue;
            room = (ResourceLocation)entry.getKey();
            break;
        }
        if (room == null) {
            return new Tuple((Object)RoomType.ROOMTYPE_BASIC, (Object)"");
        }
        RoomType type = RoomType.ROOMTYPE_BASIC;
        if (room.m_135815_().contains("omega")) {
            type = RoomType.ROOMTYPE_OMEGA;
        } else if (room.m_135815_().contains("challenge")) {
            type = RoomType.ROOMTYPE_CHALLENGE;
        } else if (room.m_135815_().contains("raw") || room.m_135815_().contains("resource")) {
            type = RoomType.ROOMTYPE_RESOURCE;
        }
        String name = room.toString();
        return new Tuple((Object)type, (Object)name);
    }

    static {
        players = new ConcurrentHashMap();
        cells = new CopyOnWriteArrayList();
        cellCache = new ConcurrentHashMap();
        startRoom = new VaultCell(0, 0, CellType.CELLTYPE_ROOM, RoomType.ROOMTYPE_START);
        northSize = defaultMapSize = 10;
        eastSize = defaultMapSize;
        southSize = defaultMapSize;
        westSize = defaultMapSize;
        discoveredRoomSizeCache = 1;
        clientTickCount = 0;
    }

    public static class MapPlayer {
        public String uuid;
        public String color;
        int x;
        int y;
        float yaw;
    }
}

