/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.map;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.proto.CellType;
import com.nodiumhosting.vaultmapper.util.MapRoomIconUtil;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.util.McClientHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VaultMapOverlayRenderer {
    public static boolean enabled = false;
    public static boolean syncErrorState = false;
    static boolean playerCentricRender = (Boolean)ClientConfig.PLAYER_CENTRIC_RENDERING.get();
    static int cutoff = (Integer)ClientConfig.PC_CUTOFF.get();
    static float mapScaleMultiplier;
    static float mapRoomWidth;
    static boolean prepped;
    static float centerX;
    static float centerZ;
    static float mapAnchorX;
    static float mapAnchorZ;
    static int playerX;
    static int playerZ;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGameOverlayEvent.Post event) {
        Object syncError;
        float offset;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!enabled) {
            return;
        }
        if (!((Boolean)ClientConfig.MAP_ENABLED.get()).booleanValue()) {
            return;
        }
        Vault vault = ClientVaults.getActive().orElse(null);
        if (vault != null && VaultUtils.isHeraldVault((Vault)vault)) {
            return;
        }
        if (!prepped) {
            VaultMapOverlayRenderer.prep();
        }
        int offsetX = (Integer)ClientConfig.MAP_X_OFFSET.get();
        int offsetZ = (Integer)ClientConfig.MAP_Y_OFFSET.get();
        if (VaultMap.currentRoom != null) {
            playerX = VaultMap.currentRoom.x;
            playerZ = VaultMap.currentRoom.z;
        } else {
            playerX = 0;
            playerZ = 0;
        }
        if (syncErrorState) {
            offset = playerCentricRender ? (float)(cutoff + 1) * mapRoomWidth : (float)(VaultMap.northSize + 1) * mapRoomWidth;
            syncError = new TextComponent("Sync Error");
            GuiComponent.m_93215_((PoseStack)event.getMatrixStack(), (Font)Minecraft.m_91087_().f_91062_, (Component)syncError, (int)((int)centerX + offsetX), (int)((int)mapAnchorZ + offsetZ - (int)offset - 9), (int)0xFFFFFF);
        }
        if (VaultMap.viewerCode != null && ((Boolean)ClientConfig.SHOW_VIEWER_CODE.get()).booleanValue()) {
            offset = playerCentricRender ? (float)(cutoff + 1) * mapRoomWidth : (float)(VaultMap.southSize + 1) * mapRoomWidth;
            syncError = new TextComponent("Viewer Code: " + VaultMap.viewerCode);
            GuiComponent.m_93215_((PoseStack)event.getMatrixStack(), (Font)Minecraft.m_91087_().f_91062_, (Component)syncError, (int)((int)centerX + offsetX), (int)((int)mapAnchorZ + offsetZ + (int)offset), (int)0xFFFFFF);
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (playerCentricRender && ((Boolean)ClientConfig.PC_BORDER.get()).booleanValue()) {
            VaultMapOverlayRenderer.renderMapBorderPC(bufferBuilder, -578781056);
        }
        if (((Boolean)ClientConfig.SHOW_TUNNELS.get()).booleanValue()) {
            for (VaultCell vaultCell : VaultMap.cells) {
                if (vaultCell.cellType != CellType.CELLTYPE_TUNNEL_X && vaultCell.cellType != CellType.CELLTYPE_TUNNEL_Z || !VaultMapOverlayRenderer.shouldRenderCell(vaultCell)) continue;
                VaultMapOverlayRenderer.renderCell(bufferBuilder, vaultCell, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(vaultCell)));
            }
        }
        for (VaultCell vaultCell : VaultMap.cells) {
            if (vaultCell.cellType != CellType.CELLTYPE_ROOM || !VaultMapOverlayRenderer.shouldRenderCell(vaultCell)) continue;
            VaultMapOverlayRenderer.renderCell(bufferBuilder, vaultCell, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(vaultCell)));
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (((Boolean)ClientConfig.SHOW_ROOM_ICONS.get()).booleanValue()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69461_();
            for (VaultCell vaultCell : VaultMap.cells) {
                if (vaultCell.cellType != CellType.CELLTYPE_ROOM || !VaultMapOverlayRenderer.shouldRenderCell(vaultCell)) continue;
                if (vaultCell.roomName == null || vaultCell.roomName.isEmpty()) {
                    vaultCell.roomName = vaultCell.roomType.name();
                }
                try {
                    ResourceLocation icon = MapRoomIconUtil.getIconForRoom(vaultCell.roomName);
                    if (icon == null) {
                        VaultMapper.LOGGER.error("Icon {} not found for room: {}", (Object)icon, (Object)vaultCell.roomName);
                        continue;
                    }
                    RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    VaultMapOverlayRenderer.renderTextureCell(bufferBuilder, vaultCell);
                }
                catch (Exception e) {
                    VaultMapper.LOGGER.error("Failed to render icon for room: " + vaultCell.roomName);
                }
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (VaultCell cell : VaultMap.cells) {
                if (cell.cellType != CellType.CELLTYPE_ROOM || !cell.inscripted && !cell.marked || !VaultMapOverlayRenderer.shouldRenderCell(cell)) continue;
                VaultMapOverlayRenderer.renderCellBorder(bufferBuilder, cell, VaultMapOverlayRenderer.parseColor(VaultMap.getCellColor(cell)));
            }
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        for (VaultMap.MapPlayer player : VaultMap.players.values()) {
            if (vault == null) continue;
            if (VaultUtils.isPvPVault((Vault)vault)) break;
            VaultMapOverlayRenderer.renderPlayerArrow(bufferBuilder, player);
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        VaultMap.MapPlayer currentPlayer = new VaultMap.MapPlayer();
        currentPlayer.x = playerX;
        currentPlayer.y = playerZ;
        currentPlayer.yaw = Minecraft.m_91087_().f_91074_.m_6080_();
        currentPlayer.color = (String)ClientConfig.POINTER_COLOR.get();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        VaultMapOverlayRenderer.renderPlayerArrow(bufferBuilder, currentPlayer);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (Minecraft.m_91087_().f_91066_.f_92099_.m_90857_()) {
            for (Map.Entry<String, VaultMap.MapPlayer> entry : VaultMap.players.entrySet()) {
                if (vault == null) continue;
                if (VaultUtils.isPvPVault((Vault)vault)) {
                    return;
                }
                VaultMapOverlayRenderer.renderPlayerName(event.getMatrixStack(), entry.getKey(), entry.getValue());
            }
        }
    }

    private static void renderPlayerName(PoseStack posestack, String uuid, VaultMap.MapPlayer data) {
        float arrowZ;
        float arrowX;
        int offsetX = (Integer)ClientConfig.MAP_X_OFFSET.get();
        int offsetZ = (Integer)ClientConfig.MAP_Y_OFFSET.get();
        if (playerCentricRender) {
            if (Math.abs(data.x - playerX) > cutoff || Math.abs(data.y - playerZ) > cutoff) {
                return;
            }
            arrowX = centerX + (float)(data.x - playerX) * mapRoomWidth + (float)offsetX;
            arrowZ = centerZ + (float)(data.y - playerZ) * mapRoomWidth + (float)offsetZ;
        } else {
            arrowX = centerX + (float)data.x * mapRoomWidth + (float)offsetX;
            arrowZ = centerZ + (float)data.y * mapRoomWidth + (float)offsetZ;
        }
        UUID id = UUID.fromString(uuid);
        GameProfile profile = McClientHelper.getOnlineProfile((UUID)id).orElse(null);
        if (profile == null) {
            return;
        }
        String name = profile.getName();
        if (name == null || name.isEmpty()) {
            return;
        }
        posestack.m_85836_();
        float scale = (float)((Integer)ClientConfig.MAP_SCALE.get()).intValue() * 0.1f * (float)(1.0 / Minecraft.m_91087_().m_91268_().m_85449_());
        posestack.m_85837_((double)((1.0f - scale) * arrowX), (double)((1.0f - scale) * arrowZ), 0.0);
        posestack.m_85841_(scale, scale, scale);
        GuiComponent.m_93208_((PoseStack)posestack, (Font)Minecraft.m_91087_().f_91062_, (String)name, (int)((int)(arrowX + (float)offsetX)), (int)((int)(arrowZ + (float)offsetZ + 10.0f)), (int)VaultMapOverlayRenderer.parseColor(data.color));
        posestack.m_85849_();
    }

    private static void renderPlayerArrow(BufferBuilder bufferBuilder, VaultMap.MapPlayer data) {
        float arrowZ;
        float arrowX;
        int offsetX = (Integer)ClientConfig.MAP_X_OFFSET.get();
        int offsetZ = (Integer)ClientConfig.MAP_Y_OFFSET.get();
        if (playerCentricRender) {
            if (Math.abs(data.x - playerX) > cutoff || Math.abs(data.y - playerZ) > cutoff) {
                return;
            }
            arrowX = centerX + (float)(data.x - playerX) * mapRoomWidth + (float)offsetX;
            arrowZ = centerZ + (float)(data.y - playerZ) * mapRoomWidth + (float)offsetZ;
        } else {
            arrowX = centerX + (float)data.x * mapRoomWidth + (float)offsetX;
            arrowZ = centerZ + (float)data.y * mapRoomWidth + (float)offsetZ;
        }
        ArrayList<Float> triag = VaultMapOverlayRenderer.getRotatedTriangle(data.yaw);
        int color = VaultMapOverlayRenderer.parseColor(data.color);
        bufferBuilder.m_5483_((double)(triag.get(0).floatValue() + arrowX), (double)(triag.get(1).floatValue() + arrowZ), 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)(triag.get(2).floatValue() + arrowX), (double)(triag.get(3).floatValue() + arrowZ), 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)(triag.get(4).floatValue() + arrowX), (double)(triag.get(5).floatValue() + arrowZ), 0.0).m_193479_(color).m_5752_();
    }

    private static ArrayList<Float> getRotatedTriangle(float yaw) {
        double arrowScale = (float)((Integer)ClientConfig.ARROW_SCALE.get()).intValue() * 0.03f;
        double x1 = (double)(-3.0f * mapRoomWidth) * arrowScale + (double)(mapRoomWidth / 2.0f);
        double y1 = (double)(-2.0f * mapRoomWidth) * arrowScale;
        double x2 = (double)(-3.0f * mapRoomWidth) * arrowScale + (double)(mapRoomWidth / 2.0f);
        double y2 = (double)(2.0f * mapRoomWidth) * arrowScale;
        double x3 = (double)(3.0f * mapRoomWidth) * arrowScale + (double)(mapRoomWidth / 2.0f);
        double y3 = (double)(0.0f * mapRoomWidth) * arrowScale;
        double cx = (x1 + x2) / 2.0;
        double cy = (y1 + y2) / 2.0;
        float radangle = (float)Math.toRadians(yaw + 90.0f);
        double[] rotatedVert1 = VaultMapOverlayRenderer.rotatePoint(x1, y1, cx, cy, radangle);
        double[] rotatedVert2 = VaultMapOverlayRenderer.rotatePoint(x2, y2, cx, cy, radangle);
        double[] rotatedVert3 = VaultMapOverlayRenderer.rotatePoint(x3, y3, cx, cy, radangle);
        ArrayList<Float> retlist = new ArrayList<Float>();
        retlist.add(Float.valueOf((float)rotatedVert1[0] - (float)cx));
        retlist.add(Float.valueOf((float)rotatedVert1[1] - (float)cy));
        retlist.add(Float.valueOf((float)rotatedVert2[0] - (float)cx));
        retlist.add(Float.valueOf((float)rotatedVert2[1] - (float)cy));
        retlist.add(Float.valueOf((float)rotatedVert3[0] - (float)cx));
        retlist.add(Float.valueOf((float)rotatedVert3[1] - (float)cy));
        return retlist;
    }

    private static double[] rotatePoint(double x, double y, double cx, double cy, double angle) {
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        double translatedX = x - cx;
        double translatedY = y - cy;
        double rotatedX = translatedX * cosTheta - translatedY * sinTheta;
        double rotatedY = translatedX * sinTheta + translatedY * cosTheta;
        double finalX = rotatedX + cx;
        double finalY = rotatedY + cy;
        return new double[]{finalX, finalY};
    }

    private static boolean shouldRenderCell(VaultCell cell) {
        if (cell.inscripted && !cell.explored && !((Boolean)ClientConfig.SHOW_INSCRIPTIONS.get()).booleanValue()) {
            return false;
        }
        return !playerCentricRender || Math.abs(cell.x - playerX) <= cutoff && Math.abs(cell.z - playerZ) <= cutoff;
    }

    public static void renderCell(BufferBuilder bufferBuilder, VaultCell cell, int color) {
        float endZ;
        float endX;
        float startZ;
        float startX;
        Vec2 cellCenter = VaultMapOverlayRenderer.getCellCenter(cell);
        float mapX = cellCenter.f_82470_;
        float mapZ = cellCenter.f_82471_;
        float roomWidth = mapRoomWidth / 2.0f;
        float tunnelLen = mapRoomWidth / 2.0f;
        if (cell.cellType == CellType.CELLTYPE_TUNNEL_X || cell.cellType == CellType.CELLTYPE_TUNNEL_Z) {
            if (cell.cellType == CellType.CELLTYPE_TUNNEL_X) {
                startX = mapX - tunnelLen;
                startZ = mapZ - roomWidth / 2.0f;
                endX = mapX + tunnelLen;
                endZ = mapZ + roomWidth / 2.0f;
            } else {
                startX = mapX - roomWidth / 2.0f;
                startZ = mapZ - tunnelLen;
                endX = mapX + roomWidth / 2.0f;
                endZ = mapZ + tunnelLen;
            }
        } else {
            startX = mapX - roomWidth;
            startZ = mapZ - roomWidth;
            endX = mapX + roomWidth;
            endZ = mapZ + roomWidth;
        }
        float minX = Math.min(startX, endX);
        float maxX = Math.max(startX, endX);
        float minZ = Math.min(startZ, endZ);
        float maxZ = Math.max(startZ, endZ);
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)minZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZ, 0.0).m_193479_(color).m_5752_();
    }

    public static void renderCellBorder(BufferBuilder bufferBuilder, VaultCell cell, int color) {
        Vec2 cellCenter = VaultMapOverlayRenderer.getCellCenter(cell);
        float mapX = cellCenter.f_82470_;
        float mapZ = cellCenter.f_82471_;
        int crop = (Integer)ClientConfig.ICON_CROP.get();
        float scale = (16.0f - (float)(2 * crop)) / 16.0f;
        float halfSize = mapRoomWidth * scale;
        float minX = mapX - halfSize;
        float maxX = mapX + halfSize;
        float minZ = mapZ - halfSize;
        float maxZ = mapZ + halfSize;
        VaultMapOverlayRenderer.renderBorder(bufferBuilder, color, minX, minZ, maxX, maxZ, 0.125f * mapRoomWidth);
    }

    public static void renderTextureCell(BufferBuilder bufferBuilder, VaultCell cell) {
        Vec2 cellCenter = VaultMapOverlayRenderer.getCellCenter(cell);
        float mapX = cellCenter.f_82470_;
        float mapZ = cellCenter.f_82471_;
        int crop = (Integer)ClientConfig.ICON_CROP.get();
        float scale = (16.0f - (float)(2 * crop)) / 16.0f;
        float halfSize = mapRoomWidth * scale;
        float minX = mapX - halfSize;
        float maxX = mapX + halfSize;
        float minZ = mapZ - halfSize;
        float maxZ = mapZ + halfSize;
        float zeroOff = (float)crop / 16.0f;
        float oneOff = 1.0f - (float)crop / 16.0f;
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_7421_(zeroOff, oneOff).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)maxZ, 0.0).m_7421_(oneOff, oneOff).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)minZ, 0.0).m_7421_(oneOff, zeroOff).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZ, 0.0).m_7421_(zeroOff, zeroOff).m_5752_();
    }

    public static void onWindowResize() {
        int w = Minecraft.m_91087_().m_91268_().m_85445_();
        int h = Minecraft.m_91087_().m_91268_().m_85446_();
        int mapSize = (int)((float)w * 0.25f);
        int baseMapRoomWidth = mapSize / 49;
        mapScaleMultiplier = (float)((Integer)ClientConfig.MAP_SCALE.get()).intValue() / 10.0f;
        mapRoomWidth = (float)baseMapRoomWidth * mapScaleMultiplier;
        VaultMapOverlayRenderer.updateAnchor();
    }

    public static void updateAnchor() {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int n = 2 * (int)mapRoomWidth;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int sideMargin = n + 9;
        switch ((Integer)ClientConfig.MAP_X_ANCHOR.get()) {
            case 0: {
                if (playerCentricRender) {
                    mapAnchorX = mapRoomWidth * (float)cutoff + (float)sideMargin;
                    break;
                }
                mapAnchorX = (float)VaultMap.westSize * mapRoomWidth + mapRoomWidth + (float)sideMargin;
                break;
            }
            case 1: {
                if (playerCentricRender) {
                    mapAnchorX = Math.max((float)width / 4.0f, mapRoomWidth * (float)cutoff + (float)sideMargin);
                    break;
                }
                mapAnchorX = Math.max((float)width / 4.0f, (float)VaultMap.westSize * mapRoomWidth + mapRoomWidth + (float)sideMargin);
                break;
            }
            case 2: {
                mapAnchorX = (float)width / 2.0f;
                break;
            }
            case 3: {
                if (playerCentricRender) {
                    mapAnchorX = Math.min((float)width - (float)width / 4.0f, (float)width - (mapRoomWidth * (float)cutoff + (float)sideMargin));
                    break;
                }
                mapAnchorX = Math.min((float)width - (float)width / 4.0f, (float)width - ((float)VaultMap.eastSize * mapRoomWidth + mapRoomWidth + (float)sideMargin));
                break;
            }
            case 4: {
                mapAnchorX = playerCentricRender ? (float)width - (mapRoomWidth * (float)cutoff + (float)sideMargin) : (float)width - ((float)VaultMap.eastSize * mapRoomWidth + mapRoomWidth + (float)sideMargin);
            }
        }
        switch ((Integer)ClientConfig.MAP_Y_ANCHOR.get()) {
            case 0: {
                if (playerCentricRender) {
                    mapAnchorZ = mapRoomWidth * (float)cutoff + (float)sideMargin;
                    break;
                }
                mapAnchorZ = (float)VaultMap.northSize * mapRoomWidth + mapRoomWidth + (float)sideMargin;
                break;
            }
            case 1: {
                if (playerCentricRender) {
                    mapAnchorZ = Math.max((float)height / 4.0f, mapRoomWidth * (float)cutoff + (float)sideMargin);
                    break;
                }
                mapAnchorZ = Math.max((float)height / 4.0f, (float)VaultMap.northSize * mapRoomWidth + mapRoomWidth + (float)sideMargin);
                break;
            }
            case 2: {
                mapAnchorZ = (float)height / 2.0f;
                break;
            }
            case 3: {
                if (playerCentricRender) {
                    mapAnchorZ = Math.min((float)height - (float)height / 4.0f, (float)height - (mapRoomWidth * (float)cutoff + (float)sideMargin));
                    break;
                }
                mapAnchorZ = Math.min((float)height - (float)height / 4.0f, (float)height - ((float)VaultMap.southSize * mapRoomWidth + mapRoomWidth + (float)sideMargin));
                break;
            }
            case 4: {
                mapAnchorZ = playerCentricRender ? (float)height - (mapRoomWidth * (float)cutoff + (float)sideMargin) : (float)height - ((float)VaultMap.southSize * mapRoomWidth + mapRoomWidth + (float)sideMargin);
            }
        }
        centerX = mapAnchorX;
        centerZ = mapAnchorZ;
    }

    public static int parseColor(String hexColor) {
        try {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static void prep() {
        playerCentricRender = (Boolean)ClientConfig.PLAYER_CENTRIC_RENDERING.get();
        cutoff = (Integer)ClientConfig.PC_CUTOFF.get();
        VaultMapOverlayRenderer.onWindowResize();
        VaultMapper.LOGGER.info("prep ran");
        prepped = true;
    }

    public static void renderMapBorderPC(BufferBuilder bufferBuilder, int color) {
        if (!playerCentricRender || !((Boolean)ClientConfig.PC_BORDER.get()).booleanValue()) {
            return;
        }
        float mapSize = (float)(((double)cutoff + 0.5) * (double)mapRoomWidth * 2.0);
        float mapSizeDelta = mapSize / 2.0f;
        float startX = centerX - mapSizeDelta;
        float startZ = centerZ - mapSizeDelta;
        float endX = centerX + mapSizeDelta;
        float endZ = centerZ + mapSizeDelta;
        VaultMapOverlayRenderer.renderBorder(bufferBuilder, color, startX, startZ, endX, endZ);
    }

    public static void renderBorder(BufferBuilder bufferBuilder, int color, float startX, float startZ, float endX, float endZ) {
        VaultMapOverlayRenderer.renderBorder(bufferBuilder, color, startX, startZ, endX, endZ, 1.0f);
    }

    public static void renderBorder(BufferBuilder bufferBuilder, int color, float startX, float startZ, float endX, float endZ, float lineWidth) {
        float minX = Math.min(startX, endX);
        float minXL = Math.min(startX, endX) + lineWidth;
        float minZ = Math.min(startZ, endZ);
        float minZL = Math.min(startZ, endZ) + lineWidth;
        float maxX = Math.max(startX, endX) - lineWidth;
        float maxXL = Math.max(startX, endX);
        float maxZ = Math.max(startZ, endZ) - lineWidth;
        float maxZL = Math.max(startZ, endZ);
        bufferBuilder.m_5483_((double)minX, (double)minZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)minZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)minZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)maxZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)maxZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minXL, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minXL, (double)minZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)minX, (double)minZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)maxZ, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxXL, (double)minZL, 0.0).m_193479_(color).m_5752_();
        bufferBuilder.m_5483_((double)maxX, (double)minZL, 0.0).m_193479_(color).m_5752_();
    }

    public static Vec2 getCellCenter(VaultCell cell) {
        if (playerCentricRender) {
            return new Vec2(centerX + (float)(cell.x - playerX) * mapRoomWidth + (float)((Integer)ClientConfig.MAP_X_OFFSET.get()).intValue(), centerZ + (float)(cell.z - playerZ) * mapRoomWidth + (float)((Integer)ClientConfig.MAP_Y_OFFSET.get()).intValue());
        }
        return new Vec2(centerX + (float)cell.x * mapRoomWidth + (float)((Integer)ClientConfig.MAP_X_OFFSET.get()).intValue(), centerZ + (float)cell.z * mapRoomWidth + (float)((Integer)ClientConfig.MAP_Y_OFFSET.get()).intValue());
    }

    static {
        prepped = false;
        mapAnchorX = 0.0f;
        mapAnchorZ = 0.0f;
    }
}

