/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.map.snapshots;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.gui.screen.VaultMapScreen;
import com.nodiumhosting.vaultmapper.map.VaultCell;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class MapSnapshot {
    public static final String mapSaveFolder = "vaultmaps/standard/";
    public static final String favoriteMapsFolder = "vaultmaps/favorite/";
    public static boolean checkedDirs = false;
    public static MapSnapshot lastSnapshotCache;
    @SerializedName(value="v")
    public int version = 2;
    @SerializedName(value="cl")
    public List<VaultCell> cells;

    public static void onVaultExit(UUID vaultUUID) {
        if (lastSnapshotCache == null) {
            return;
        }
        MapSnapshot.addMap(vaultUUID, lastSnapshotCache);
    }

    public static void toggleFavorite(UUID uuid) {
        MapSnapshot.makeSureFoldersExist();
        String mapPath = mapSaveFolder + String.valueOf(uuid) + ".vaultmap";
        String favPath = favoriteMapsFolder + String.valueOf(uuid) + ".vaultmap";
        File favorite = new File(favPath);
        if (favorite.exists()) {
            favorite.delete();
            return;
        }
        File map = new File(mapPath);
        if (!map.exists()) {
            return;
        }
        try {
            Files.copy(map.toPath(), favorite.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            VaultMapper.LOGGER.error("Couldn't copy map to favorite");
        }
    }

    public static MapSnapshot takeSnapshot() {
        ArrayList<VaultCell> cells = new ArrayList<VaultCell>(VaultMap.getCells());
        return new MapSnapshot(cells);
    }

    public static void addMap(UUID uuid, MapSnapshot snapshot) {
        MapSnapshot.makeSureFoldersExist();
        try {
            FileOutputStream fos = new FileOutputStream(mapSaveFolder + uuid.toString() + ".vaultmap");
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            OutputStreamWriter writer = new OutputStreamWriter(gzos);
            Util.MAP_GSON.toJson((Object)snapshot, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            VaultMapper.LOGGER.error("Couldn't create map save file");
        }
        MapSnapshot.removeExcessMaps();
    }

    public static void makeSureFoldersExist() {
        if (checkedDirs) {
            return;
        }
        File favs = new File(favoriteMapsFolder);
        File maps = new File(mapSaveFolder);
        if (!favs.exists()) {
            favs.mkdirs();
        }
        if (!maps.exists()) {
            maps.mkdirs();
        }
        checkedDirs = true;
    }

    public static void removeExcessMaps() {
        int maxMaps = (Integer)ClientConfig.MAX_MAPS_SAVED.get();
        if (maxMaps < 0) {
            return;
        }
        File folder = new File(mapSaveFolder);
        File[] files = folder.listFiles();
        if (files == null || files.length <= maxMaps) {
            return;
        }
        Arrays.sort(files, Comparator.comparingLong(File::lastModified));
        int filesToDelete = files.length - maxMaps;
        for (int i = 0; i < filesToDelete; ++i) {
            files[i].delete();
        }
    }

    public static Optional<MapSnapshot> from(UUID uuid) {
        return MapSnapshot.from(uuid.toString());
    }

    public static Optional<MapSnapshot> from(String filename) {
        MapSnapshot.makeSureFoldersExist();
        String mapPath = mapSaveFolder + filename + ".vaultmap";
        String favPath = favoriteMapsFolder + filename + ".vaultmap";
        Optional<MapSnapshot> normalMap = MapSnapshot.readMapFromPath(mapPath);
        if (normalMap.isPresent()) {
            return normalMap;
        }
        return MapSnapshot.readMapFromPath(favPath);
    }

    public static Optional<MapSnapshot> readMapFromPath(String path) {
        File mapFile = new File(path);
        if (!mapFile.exists()) {
            return Optional.empty();
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            InputStreamReader reader = new InputStreamReader(gzis);
            Type saveType = new TypeToken<MapSnapshot>(){}.getType();
            return Optional.of((MapSnapshot)Util.MAP_GSON.fromJson((Reader)reader, saveType));
        }
        catch (IOException e) {
            VaultMapper.LOGGER.error("Couldn't read map save file");
            return Optional.empty();
        }
    }

    public MapSnapshot(List<VaultCell> cells) {
        this.cells = cells;
    }

    public static void openScreen(String uuid) {
        Minecraft.m_91087_().m_91152_((Screen)new VaultMapScreen(uuid));
    }

    public void openScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new VaultMapScreen(Optional.of(this)));
    }
}

