/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.network.sync;

import com.google.gson.GsonBuilder;
import com.nodiumhosting.vaultmapper.VaultMapper;
import com.nodiumhosting.vaultmapper.config.ClientConfig;
import com.nodiumhosting.vaultmapper.gui.ToastMessageManager;
import com.nodiumhosting.vaultmapper.map.VaultMap;
import com.nodiumhosting.vaultmapper.map.VaultMapOverlayRenderer;
import com.nodiumhosting.vaultmapper.proto.CellType;
import com.nodiumhosting.vaultmapper.proto.Color;
import com.nodiumhosting.vaultmapper.proto.Message;
import com.nodiumhosting.vaultmapper.proto.MessageType;
import com.nodiumhosting.vaultmapper.proto.PlayerDisconnect;
import com.nodiumhosting.vaultmapper.proto.RoomType;
import com.nodiumhosting.vaultmapper.proto.Toast;
import com.nodiumhosting.vaultmapper.proto.Vault;
import com.nodiumhosting.vaultmapper.proto.VaultCell;
import com.nodiumhosting.vaultmapper.proto.VaultPlayer;
import com.nodiumhosting.vaultmapper.proto.ViewerCode;
import com.nodiumhosting.vaultmapper.util.Util;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class SyncClient
extends WebSocketClient {
    private final Timer keepConnectedTimer = new Timer();
    private final SyncClient self;
    MovePacket old_data = new MovePacket("", "", 0, 0, 0.0f);
    private boolean keepMeOn = false;

    public SyncClient(String playerUUID, String vaultID) {
        super(URI.create((String)ClientConfig.VMSYNC_SERVER.get() + "/?vaultID=" + vaultID + "&uuid=" + playerUUID));
        this.self = this;
        int timerPeriod = 10000;
        this.keepConnectedTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SyncClient.this.keepMeOn) {
                    if (SyncClient.this.self.isOpen()) {
                        SyncClient.this.sendKeepalive();
                    } else {
                        SyncClient.this.self.reconnect();
                    }
                }
            }
        }, timerPeriod, (long)timerPeriod);
    }

    public void sendKeepalive() {
        if (this.isClosing() || this.isClosed()) {
            // empty if block
        }
        this.send("keep_me_alive");
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.keepMeOn = true;
        VaultMapOverlayRenderer.syncErrorState = false;
    }

    public void onMessage(ByteBuffer buf) {
        try {
            Message msg = Message.parseFrom(buf);
            switch (msg.getType()) {
                case VAULT: {
                    Vault data = msg.getVault();
                    for (VaultCell cell : data.getCellsList()) {
                        com.nodiumhosting.vaultmapper.map.VaultCell vaultCell = this.CellFromPacket(cell);
                        VaultMap.addOrReplaceCell(vaultCell);
                    }
                    break;
                }
                case VAULT_PLAYER: {
                    VaultPlayer data = msg.getVaultPlayer();
                    String uuid = data.getUuid();
                    Color color = data.getColor();
                    int x = data.getX();
                    int z = data.getZ();
                    float yaw = data.getYaw();
                    String red = Integer.toHexString(color.getR());
                    String green = Integer.toHexString(color.getG());
                    String blue = Integer.toHexString(color.getB());
                    Object paddedRed = red.length() == 1 ? "0" + red : red;
                    Object paddedGreen = green.length() == 1 ? "0" + green : green;
                    Object paddedBlue = blue.length() == 1 ? "0" + blue : blue;
                    String hex = "#" + (String)paddedRed + (String)paddedGreen + (String)paddedBlue;
                    VaultMap.updatePlayerMapData(uuid, hex, x, z, yaw);
                    break;
                }
                case VAULT_CELL: {
                    VaultCell data = msg.getVaultCell();
                    com.nodiumhosting.vaultmapper.map.VaultCell cell = this.CellFromPacket(data);
                    VaultMap.addOrReplaceCell(cell);
                    break;
                }
                case PLAYER_DISCONNECT: {
                    PlayerDisconnect data = msg.getPlayerDisconnect();
                    VaultMap.removePlayerMapData(data.getUuid());
                    break;
                }
                case TOAST: {
                    Toast data = msg.getToast();
                    ToastMessageManager.displayToast(data.getMessage());
                    break;
                }
                case VIEWER_CODE: {
                    ViewerCode data = msg.getViewerCode();
                    VaultMap.viewerCode = data.getCode();
                    break;
                }
                default: {
                    VaultMapper.LOGGER.info("Something weird with onMessage");
                }
            }
        }
        catch (Exception e) {
            VaultMapper.LOGGER.error("Sync WS Error: " + String.valueOf(e));
        }
    }

    private com.nodiumhosting.vaultmapper.map.VaultCell CellFromPacket(VaultCell data) {
        int x = data.getX();
        int z = data.getZ();
        CellType cellType = data.getCellType();
        RoomType roomType = data.getRoomType();
        com.nodiumhosting.vaultmapper.map.VaultCell cell = new com.nodiumhosting.vaultmapper.map.VaultCell(x, z, cellType, roomType);
        cell.roomName = data.getRoomName();
        cell.explored = data.getExplored();
        cell.inscripted = data.getInscribed();
        cell.marked = data.getMarked();
        return cell;
    }

    private VaultCell PCellFromCell(com.nodiumhosting.vaultmapper.map.VaultCell cell) {
        return VaultCell.newBuilder().setX(cell.x).setZ(cell.z).setCellType(cell.cellType).setRoomType(cell.roomType).setRoomName(cell.roomName).setExplored(cell.explored).setInscribed(cell.inscripted).setMarked(cell.marked).build();
    }

    public void onMessage(String message) {
        try {
            Capsule dataCapsule = (Capsule)new GsonBuilder().create().fromJson(message, Capsule.class);
            if (dataCapsule.type.equals(String.valueOf(PacketType.MOVE.getValue()))) {
                MovePacket movePacket = (MovePacket)new GsonBuilder().create().fromJson(dataCapsule.data, MovePacket.class);
                VaultMap.updatePlayerMapData(movePacket.uuid, movePacket.color, movePacket.x, movePacket.z, movePacket.yaw);
            } else if (dataCapsule.type.equals(String.valueOf(PacketType.CELL.getValue()))) {
                com.nodiumhosting.vaultmapper.map.VaultCell cellPacket = (com.nodiumhosting.vaultmapper.map.VaultCell)new GsonBuilder().create().fromJson(dataCapsule.data, com.nodiumhosting.vaultmapper.map.VaultCell.class);
                VaultMap.addOrReplaceCell(cellPacket);
            } else if (dataCapsule.type.equals(String.valueOf(PacketType.LEAVE.getValue()))) {
                LeavePacket leavePacket = (LeavePacket)new GsonBuilder().create().fromJson(dataCapsule.data, LeavePacket.class);
                VaultMap.removePlayerMapData(leavePacket.uuid);
            }
        }
        catch (Exception e) {
            VaultMapper.LOGGER.error("Sync WS Error: " + String.valueOf(e));
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        VaultMapOverlayRenderer.syncErrorState = true;
    }

    public void onError(Exception ex) {
        VaultMapOverlayRenderer.syncErrorState = true;
        VaultMapper.LOGGER.error("Sync WS Error: " + ex.toString());
    }

    public void closeGracefully() {
        this.keepMeOn = false;
        this.keepConnectedTimer.cancel();
        this.close();
    }

    public void sendCellPacket(com.nodiumhosting.vaultmapper.map.VaultCell cell) {
        if (this.isOpen()) {
            this.send(Message.newBuilder().setType(MessageType.VAULT_CELL).setVaultCell(this.PCellFromCell(cell)).build().toByteArray());
        }
    }

    private Color getSyncColor() {
        String col = (String)ClientConfig.SYNC_COLOR.get();
        if (col.equals("random")) {
            col = Util.RandomColor();
            ClientConfig.SYNC_COLOR.set((Object)col);
        }
        int R = Integer.parseInt(col.substring(1, 3), 16);
        int G = Integer.parseInt(col.substring(3, 5), 16);
        int B = Integer.parseInt(col.substring(5, 7), 16);
        return Color.newBuilder().setR(R).setG(G).setB(B).build();
    }

    public void sendMovePacket(String name, int cellX, int cellZ, float rotation) {
        MovePacket data;
        if (this.isOpen() && !this.old_data.equals(data = new MovePacket(name, "", cellX, cellZ, rotation))) {
            this.old_data = data;
            this.send(Message.newBuilder().setType(MessageType.VAULT_PLAYER).setVaultPlayer(VaultPlayer.newBuilder().setUuid(name).setX(cellX).setZ(cellZ).setYaw(rotation).setColor(this.getSyncColor()).build()).build().toByteArray());
        }
    }

    class MovePacket {
        public String uuid;
        public String color;
        public int x;
        public int z;
        public float yaw;

        public MovePacket(String uuid, String color, int x, int z, float yaw) {
            this.uuid = uuid;
            this.color = color;
            this.x = x;
            this.z = z;
            this.yaw = yaw;
        }

        public boolean equals(MovePacket data) {
            return data.uuid.equals(this.uuid) && data.color.equals(this.color) && data.x == this.x && data.z == this.z && data.yaw == this.yaw;
        }
    }

    class Capsule {
        public String type;
        public String data;

        public Capsule(String type, String data) {
            this.type = type;
            this.data = data;
        }
    }

    static enum PacketType {
        JOIN("0"),
        LEAVE("1"),
        CELL("2"),
        MOVE("3");

        private final String value;

        private PacketType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    class LeavePacket {
        public String uuid;
        public String color;

        LeavePacket() {
        }
    }
}

