/*
 * Decompiled with CFR 0.152.
 */
package com.nodiumhosting.vaultmapper.util;

import iskallia.vault.init.ModConfigs;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class MapRoomIconUtil {
    public static ResourceLocation getIconForRoom(String roomName) {
        ResourceLocation icon;
        String path = roomName.toLowerCase();
        if (path.contains("start")) {
            icon = BaseIcons.ROOM_START.getResourceLocation();
        } else {
            Optional customIcon = ModConfigs.VAULT_MAP_ICONS.getIconForRoom(new ResourceLocation(path));
            if (customIcon.isPresent()) {
                String iconNamespace = ((ResourceLocation)customIcon.get()).m_135827_();
                String iconPath = ((ResourceLocation)customIcon.get()).m_135815_();
                icon = new ResourceLocation(iconNamespace, "textures/" + iconPath + ".png");
            } else {
                icon = path.contains("boss") ? BaseIcons.ROOM_BOSS.getResourceLocation() : (path.contains("raid") ? BaseIcons.ROOM_RAID.getResourceLocation() : (path.contains("farm") ? BaseIcons.ROOM_FARM.getResourceLocation() : (path.contains("emerald_cave") ? BaseIcons.ROOM_EMERALD_CAVES.getResourceLocation() : (path.contains("diamond_cave") ? BaseIcons.ROOM_DIAMOND_CAVES.getResourceLocation() : (path.contains("chromatic_cave") ? BaseIcons.ROOM_CHROMATIC_CAVES.getResourceLocation() : (path.contains("modded_cave") ? BaseIcons.ROOM_MODDED_CAVES.getResourceLocation() : (path.contains("wildwest") ? BaseIcons.ROOM_WILD_WEST.getResourceLocation() : (path.contains("cube") ? BaseIcons.ROOM_CUBE.getResourceLocation() : (path.contains("end") ? BaseIcons.ROOM_END.getResourceLocation() : (path.contains("nether") ? BaseIcons.ROOM_NETHER.getResourceLocation() : (path.contains("quarry") ? BaseIcons.ROOM_QUARRY.getResourceLocation() : (path.contains("omega") ? BaseIcons.ROOM_OMEGA.getResourceLocation() : (path.contains("challenge") ? BaseIcons.ROOM_CHALLENGE.getResourceLocation() : (path.contains("raw") ? BaseIcons.ROOM_RAW.getResourceLocation() : (path.contains("/ore") ? BaseIcons.ROOM_ORE.getResourceLocation() : BaseIcons.ROOM_COMMON.getResourceLocation())))))))))))))));
            }
        }
        return icon;
    }

    public static enum BaseIcons {
        ROOM_START("the_vault:textures/gui/map/start.png"),
        ROOM_COMMON("the_vault:textures/gui/map/room.png"),
        ROOM_CHALLENGE("the_vault:textures/gui/map/room_challenge.png"),
        ROOM_OMEGA("the_vault:textures/gui/map/room_omega.png"),
        ROOM_RAW("the_vault:textures/gui/map/raw.png"),
        ROOM_ORE("the_vault:textures/gui/map/ore.png"),
        ROOM_BOSS("the_vault:textures/gui/map/boss.png"),
        ROOM_RAID("the_vault:textures/gui/map/raid.png"),
        ROOM_FARM("the_vault:textures/gui/map/farm.png"),
        ROOM_EMERALD_CAVES("the_vault:textures/gui/map/emerald_caves.png"),
        ROOM_DIAMOND_CAVES("the_vault:textures/gui/map/diamond_caves.png"),
        ROOM_CHROMATIC_CAVES("the_vault:textures/gui/map/chromatic_caves.png"),
        ROOM_MODDED_CAVES("the_vault:textures/gui/map/vm_modded_caves.png"),
        ROOM_WILD_WEST("the_vault:textures/gui/map/vm_wild_west.png"),
        ROOM_CUBE("the_vault:textures/gui/map/vm_cube.png"),
        ROOM_END("the_vault:textures/gui/map/vm_end.png"),
        ROOM_NETHER("the_vault:textures/gui/map/vm_nether.png"),
        ROOM_QUARRY("the_vault:textures/gui/map/vm_quarry.png");

        private final ResourceLocation resourceLocation;

        private BaseIcons(String path) {
            this.resourceLocation = new ResourceLocation(path);
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

