/*
 * Decompiled with CFR 0.152.
 */
package simplystats.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import simplystats.SimplyStatsMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplyStatsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SimplyStatsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Mining_EXP = message.data.Mining_EXP;
                    variables.Traveling_EXP = message.data.Traveling_EXP;
                    variables.Slaying_EXP = message.data.Slaying_EXP;
                    variables.XPlayer = message.data.XPlayer;
                    variables.ZPlayer = message.data.ZPlayer;
                    variables.UI_SHOW = message.data.UI_SHOW;
                    variables.Traveling_EXP_NEED = message.data.Traveling_EXP_NEED;
                    variables.Treveling_LVL = message.data.Treveling_LVL;
                    variables.Mining_EXP_NEED = message.data.Mining_EXP_NEED;
                    variables.Mining_LVL = message.data.Mining_LVL;
                    variables.Slaying_EXP_NEED = message.data.Slaying_EXP_NEED;
                    variables.Slaying_LVL = message.data.Slaying_LVL;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Mining_EXP = 0.0;
        public double Traveling_EXP = 0.0;
        public double Slaying_EXP = 0.0;
        public double XPlayer = 0.0;
        public double ZPlayer = 0.0;
        public boolean UI_SHOW = true;
        public double Traveling_EXP_NEED = 500.0;
        public double Treveling_LVL = 1.0;
        public double Mining_EXP_NEED = 50.0;
        public double Mining_LVL = 1.0;
        public double Slaying_EXP_NEED = 500.0;
        public double Slaying_LVL = 1.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SimplyStatsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Mining_EXP", this.Mining_EXP);
            nbt.m_128347_("Traveling_EXP", this.Traveling_EXP);
            nbt.m_128347_("Slaying_EXP", this.Slaying_EXP);
            nbt.m_128347_("XPlayer", this.XPlayer);
            nbt.m_128347_("ZPlayer", this.ZPlayer);
            nbt.m_128379_("UI_SHOW", this.UI_SHOW);
            nbt.m_128347_("Traveling_EXP_NEED", this.Traveling_EXP_NEED);
            nbt.m_128347_("Treveling_LVL", this.Treveling_LVL);
            nbt.m_128347_("Mining_EXP_NEED", this.Mining_EXP_NEED);
            nbt.m_128347_("Mining_LVL", this.Mining_LVL);
            nbt.m_128347_("Slaying_EXP_NEED", this.Slaying_EXP_NEED);
            nbt.m_128347_("Slaying_LVL", this.Slaying_LVL);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Mining_EXP = nbt.m_128459_("Mining_EXP");
            this.Traveling_EXP = nbt.m_128459_("Traveling_EXP");
            this.Slaying_EXP = nbt.m_128459_("Slaying_EXP");
            this.XPlayer = nbt.m_128459_("XPlayer");
            this.ZPlayer = nbt.m_128459_("ZPlayer");
            this.UI_SHOW = nbt.m_128471_("UI_SHOW");
            this.Traveling_EXP_NEED = nbt.m_128459_("Traveling_EXP_NEED");
            this.Treveling_LVL = nbt.m_128459_("Treveling_LVL");
            this.Mining_EXP_NEED = nbt.m_128459_("Mining_EXP_NEED");
            this.Mining_LVL = nbt.m_128459_("Mining_LVL");
            this.Slaying_EXP_NEED = nbt.m_128459_("Slaying_EXP_NEED");
            this.Slaying_LVL = nbt.m_128459_("Slaying_LVL");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("simply_stats", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Mining_EXP = original.Mining_EXP;
            clone.Traveling_EXP = original.Traveling_EXP;
            clone.Slaying_EXP = original.Slaying_EXP;
            clone.XPlayer = original.XPlayer;
            clone.ZPlayer = original.ZPlayer;
            clone.UI_SHOW = original.UI_SHOW;
            clone.Traveling_EXP_NEED = original.Traveling_EXP_NEED;
            clone.Treveling_LVL = original.Treveling_LVL;
            clone.Mining_EXP_NEED = original.Mining_EXP_NEED;
            clone.Mining_LVL = original.Mining_LVL;
            clone.Slaying_EXP_NEED = original.Slaying_EXP_NEED;
            clone.Slaying_LVL = original.Slaying_LVL;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

