/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.wrapper;

import com.hyfata.najoan.koreanpatch.client.GUIStatus;
import com.hyfata.najoan.koreanpatch.mixin.accessor.TextFieldHelperAccessor;
import com.hyfata.najoan.koreanpatch.process.HangulProcessor;
import com.hyfata.najoan.koreanpatch.process.LangTypeManager;
import com.hyfata.najoan.koreanpatch.process.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.HangulUtil;
import com.hyfata.najoan.koreanpatch.wrapper.InterfaceIMEWrapper;
import com.hyfata.najoan.koreanpatch.wrapper.handler.IMEWrapperHandler;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WrapperTextFieldHelper
implements InterfaceIMEWrapper {
    private final TextFieldHelperAccessor accessor;
    private final class_310 client = class_310.method_1551();

    public WrapperTextFieldHelper(TextFieldHelperAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void modifyText(String str) {
        String text = this.getText();
        if (this.accessor.getSelectionPos() != this.accessor.getCursorPos()) {
            text = this.accessor.runDeleteSelection(text);
        }
        this.accessor.setCursorPos(class_3532.method_15340((int)this.accessor.getCursorPos(), (int)0, (int)text.length()));
        String s = new StringBuilder(text).replace(this.accessor.getCursorPos() - 1, this.accessor.getCursorPos(), str).toString();
        if (this.accessor.getStringFilter().test(s)) {
            this.accessor.getStringSetter().accept(s);
            int cursorPos = Math.min(s.length(), this.accessor.getCursorPos() - 1 + str.length());
            this.accessor.setCursorPos(cursorPos);
            this.accessor.setSelectionPos(cursorPos);
        }
    }

    @Override
    public int getCursor() {
        return this.accessor.getSelectionPos();
    }

    @Override
    public void writeText(String str) {
        this.accessor.runInsert(this.getText(), str);
    }

    private boolean onBackspaceKeyPressed() {
        return IMEWrapperHandler.onBackspaceKeyPressed(this, this.getCursor(), this.getText());
    }

    private int getModifiers() {
        boolean shift;
        boolean bl = shift = class_3675.method_15987((class_1041)this.client.method_22683(), (int)340) || class_3675.method_15987((class_1041)this.client.method_22683(), (int)344);
        if (shift) {
            return 1;
        }
        return 0;
    }

    private String getText() {
        return this.accessor.getStringGetter().get();
    }

    private void setText(String str) {
        if (this.accessor.getStringFilter().test(str)) {
            this.accessor.getStringSetter().accept(str);
        }
    }

    private boolean onHangulCharTyped(int keyCode, int modifiers) {
        String text = this.getText();
        if (text.isEmpty()) {
            return false;
        }
        return IMEWrapperHandler.onHangulCharTyped(this, keyCode, modifiers, text, this.accessor.selectedText(text).isEmpty());
    }

    public void deleteCharsFromCursor(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client.field_1755 != null && !GUIStatus.getInstance().isBypassInjection() && this.onBackspaceKeyPressed()) {
            ci.cancel();
        }
    }

    public void insertChar(char chr, CallbackInfoReturnable<Boolean> cir) {
        if (this.client.field_1755 != null && LangTypeManager.getInstance().isKorean()) {
            cir.setReturnValue((Object)Boolean.TRUE);
            if (chr == ' ') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.getCursor() : -1;
                return;
            }
            int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                return;
            }
            Objects.requireNonNull(KeyboardLayout.INSTANCE);
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.getCursor();
            int modifiers = this.getModifiers();
            if (cursorPosition == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
                this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
            }
        }
    }

    public void insertString(String string, CallbackInfo ci) {
        boolean colored = false;
        for (char chr : string.toCharArray()) {
            if (this.client.field_1755 == null || !LangTypeManager.getInstance().isKorean()) continue;
            ci.cancel();
            if (chr == ' ' || chr == '\n') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.getCursor() : -1;
                continue;
            }
            if (chr == '\u00a7') {
                this.writeText(String.valueOf(chr));
                colored = true;
                continue;
            }
            if (colored) {
                this.writeText(String.valueOf(chr));
                colored = false;
                continue;
            }
            int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                continue;
            }
            Objects.requireNonNull(KeyboardLayout.INSTANCE);
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.getCursor();
            int modifiers = this.getModifiers();
            if (cursorPosition != 0 && HangulProcessor.isHangulCharacter(curr) && this.onHangulCharTyped(chr, modifiers)) continue;
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }
}

