/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.process.handler;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.data.ConfigManager;
import com.hyfata.najoan.koreanpatch.data.LangTypeManager;
import com.hyfata.najoan.koreanpatch.data.config.category.CategoryInput;
import com.hyfata.najoan.koreanpatch.data.config.category.input.AutoLangTypeMode;
import com.hyfata.najoan.koreanpatch.data.provider.LanguageType;
import com.hyfata.najoan.koreanpatch.data.storage.InputStatus;
import com.hyfata.najoan.koreanpatch.data.storage.InputStatusStorage;
import com.hyfata.najoan.koreanpatch.gui.GUIStatus;
import com.hyfata.najoan.koreanpatch.process.ime.InputController;
import com.hyfata.najoan.koreanpatch.process.ime.InputManager;
import com.hyfata.najoan.koreanpatch.util.ReflectionFieldChecker;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CartographyTableScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.JigsawBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.inventory.StructureBlockEditScreen;

public class EventListener {
    private static ArrayList<Class<?>> patchedScreenClazz = new ArrayList();
    private static final Class<?>[] injectionBypassScreens = new Class[]{JigsawBlockEditScreen.class, StructureBlockEditScreen.class};

    public static void onClientStarted() {
        KoreanPatchClient.clientStarted();
        String[] imeDisabledScreens = new String[]{"arm32x.minecraft.commandblockide.client.gui.screen.CommandIDEScreen", "xaero.map.gui.GuiMap"};
        Class[] imeDisabledClasses = new Class[]{KeyBindsScreen.class, ContainerScreen.class, InventoryScreen.class, FurnaceScreen.class, CraftingScreen.class, EnchantmentScreen.class, BeaconScreen.class, ShulkerBoxScreen.class, SmokerScreen.class, CartographyTableScreen.class, BlastFurnaceScreen.class, SmithingScreen.class, GrindstoneScreen.class, BrewingStandScreen.class, LoomScreen.class, StonecutterScreen.class, MerchantScreen.class};
        patchedScreenClazz = EventListener.getExistingClasses(imeDisabledScreens);
        patchedScreenClazz.addAll(Arrays.asList(imeDisabledClasses));
    }

    public static void afterScreenChange() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null || !KoreanPatchClient.loaded) {
            return;
        }
        GUIStatus.setBypassInjection(EventListener.isInjectionBypassScreen(screen));
        boolean hasTextInput = EventListener.isScreenPatched(screen) || EventListener.hasTextField(screen);
        InputController controller = InputManager.getController();
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        if (controller != null && categoryInput.isAutoImeSwitch()) {
            controller.setFocus(!hasTextInput);
        }
        if (hasTextInput) {
            EventListener.setLangType(screen);
        }
    }

    public static void onClientTick() {
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ == null && !GUIStatus.isShouldUseIME() && categoryInput.isDisableImeWhenPlaying()) {
            InputManager.getController().setFocus(false);
        } else if (GUIStatus.isShouldUseIME()) {
            InputManager.getController().setFocus(true);
        }
    }

    private static void setLangType(Screen screen) {
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        AutoLangTypeMode mode = categoryInput.getAutoLangTypeMode();
        if (mode != AutoLangTypeMode.AUTO) {
            switch (mode) {
                case KOREAN: {
                    LangTypeManager.getInstance().setCurrentType(LanguageType.KO);
                    break;
                }
                case ENGLISH: {
                    LangTypeManager.getInstance().setCurrentType(LanguageType.EN);
                    break;
                }
                case IME: {
                    InputManager.getController().setFocus(true);
                }
            }
        }
        if (categoryInput.isMemoryLangTypePerScreen()) {
            EventListener.setStoredLangType(screen);
        }
    }

    private static void setStoredLangType(Screen screen) {
        InputStatus inputStatus = InputStatusStorage.getInstance().get(screen);
        if (inputStatus != null) {
            LangTypeManager.getInstance().setCurrentType(inputStatus.getLanguageType());
            InputManager.getController().setFocus(inputStatus.isImeFocus());
        } else {
            InputStatusStorage.getInstance().add(screen);
        }
        InputStatusStorage.getInstance().save();
    }

    private static ArrayList<Class<?>> getExistingClasses(String[] clazz) {
        ArrayList result = new ArrayList();
        for (String className : clazz) {
            try {
                Class<?> cls = Class.forName(className);
                result.add(cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isInjectionBypassScreen(Screen screen) {
        return Arrays.stream(injectionBypassScreens).anyMatch(cls -> cls.isInstance(screen));
    }

    private static boolean isScreenPatched(Screen screen) {
        boolean screenPatched = false;
        for (Class<?> cls : patchedScreenClazz) {
            if (!cls.isInstance(screen)) continue;
            screenPatched = true;
            break;
        }
        return screenPatched;
    }

    private static boolean hasTextField(Screen screen) {
        boolean hasTextFieldWidget = ReflectionFieldChecker.hasFieldOfType(screen, EditBox.class);
        boolean hasSelectionManager = ReflectionFieldChecker.hasFieldOfType(screen, TextFieldHelper.class);
        return hasTextFieldWidget || hasSelectionManager;
    }
}

