/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RenderUtil {
    private static final Minecraft client = Minecraft.m_91087_();

    public static void drawCenteredText(PoseStack context, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawCenteredText(context, text, x, y, -1);
    }

    public static void drawCenteredText(PoseStack context, FormattedCharSequence text, float x, float y, int color) {
        Font textRenderer = RenderUtil.client.f_91062_;
        float textWidth = textRenderer.m_92724_(text);
        float xPosition = x - textWidth / 2.0f;
        Objects.requireNonNull(RenderUtil.client.f_91062_);
        float yPosition = y - 9.0f / 2.0f;
        RenderUtil.drawText(context, text, xPosition, yPosition, color);
    }

    public static void drawText(PoseStack context, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawText(context, text, x, y, -1);
    }

    public static void drawText(PoseStack context, FormattedCharSequence text, float x, float y, int color) {
        Font textRenderer = RenderUtil.client.f_91062_;
        RenderSystem.m_69478_();
        textRenderer.m_92877_(context, text, x, y, color);
        RenderSystem.m_69461_();
    }

    public static void fill(PoseStack context, float x1, float y1, float x2, float y2, int color) {
        float i;
        Matrix4f matrix = context.m_85850_().m_252922_();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, x1, y1, 0.0f).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y2, 0.0f).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y2, 0.0f).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, 0.0f).m_193479_(color).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
    }

    public static void drawVertexCircleFrame(PoseStack context, float centerX, float centerY, float radius, int frameColor, float frameThickness, VertexDirection direction) {
        float innerRadius = radius - frameThickness;
        if (innerRadius < 0.0f) {
            throw new IllegalArgumentException("Frame thickness cannot be greater than the outer radius.");
        }
        int steps = 18;
        float angleStep = 1.5707964f / (float)steps;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.m_14089_((float)angleStep);
        float sinDelta = Mth.m_14031_((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, innerRadius, cos, sin, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, cos, sin, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    public static void drawVertexSuperellipseFrame(PoseStack context, float centerX, float centerY, float radiusX, float radiusY, float exponent, int frameColor, float frameThickness, VertexDirection direction) {
        int steps = 36;
        float angleStep = 1.5707964f / (float)steps;
        float correctedExponent = 2.0f / exponent;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.m_14089_((float)angleStep);
        float sinDelta = Mth.m_14031_((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float projX = (float)Math.pow(Mth.m_14154_((float)cos), correctedExponent);
            float projY = (float)Math.pow(Mth.m_14154_((float)sin), correctedExponent);
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX - frameThickness, radiusY - frameThickness, projX, projY, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX, radiusY, projX, projY, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radius, float projX, float projY, VertexDirection direction) {
        return RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, radius, projX, projY, direction);
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radiusX, float radiusY, float projX, float projY, VertexDirection direction) {
        float x;
        return new float[]{x, switch (direction) {
            case VertexDirection.TOP_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.TOP_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.BOTTOM_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY + radiusY * projY;
            }
            case VertexDirection.BOTTOM_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY + radiusY * projY;
            }
            default -> throw new IllegalArgumentException("Invalid VertexDirection");
        }};
    }

    public static enum VertexDirection {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

