/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.animation;

import java.util.function.DoubleUnaryOperator;

public enum EasingFunctions {
    Linear(x -> x),
    easeInSine(x -> 1.0 - Math.cos(x * Math.PI / 2.0)),
    easeOutSine(x -> Math.sin(x * Math.PI / 2.0)),
    easeInOutSine(x -> -(Math.cos(Math.PI * x) - 1.0) / 2.0),
    easeInQuad(x -> x * x),
    easeOutQuad(x -> 1.0 - (1.0 - x) * (1.0 - x)),
    easeInOutQuad(x -> x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0),
    easeInCubic(x -> x * x * x),
    easeOutCubic(x -> 1.0 - Math.pow(1.0 - x, 3.0)),
    easeInOutCubic(x -> x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0),
    easeInQuart(x -> x * x * x * x),
    easeOutQuart(x -> 1.0 - Math.pow(1.0 - x, 4.0)),
    easeInOutQuart(x -> x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0),
    easeInQuint(x -> x * x * x * x * x),
    easeOutQuint(x -> 1.0 - Math.pow(1.0 - x, 5.0)),
    easeInOutQuint(x -> x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0),
    easeInExpo(x -> x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0)),
    easeOutExpo(x -> x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x)),
    easeInOutExpo(x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0))),
    easeInCirc(x -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0))),
    easeOutCirc(x -> Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0))),
    easeInOutCirc(x -> x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0),
    easeInBack(x -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return c3 * x * x * x - c1 * x * x;
    }),
    easeOutBack(x -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return 1.0 + c3 * Math.pow(x - 1.0, 3.0) + c1 * Math.pow(x - 1.0, 2.0);
    }),
    easeInOutBack(x -> {
        double c1 = 1.70158;
        double c2 = c1 * 1.525;
        return x < 0.5 ? Math.pow(2.0 * x, 2.0) * ((c2 + 1.0) * 2.0 * x - c2) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * ((c2 + 1.0) * (x * 2.0 - 2.0) + c2) + 2.0) / 2.0;
    }),
    easeInElastic(x -> {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * c4));
    }),
    easeOutElastic(x -> {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * c4) + 1.0);
    }),
    easeInOutElastic(x -> {
        double c5 = 1.3962634015954636;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0));
    }),
    easeOutBounce(x -> {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 1.0 / d1) {
            return n1 * x * x;
        }
        if (x < 2.0 / d1) {
            return n1 * (x -= 1.5 / d1) * x + 0.75;
        }
        if (x < 2.5 / d1) {
            return n1 * (x -= 2.25 / d1) * x + 0.9375;
        }
        return n1 * (x -= 2.625 / d1) * x + 0.984375;
    }),
    easeInBounce(x -> 1.0 - easeOutBounce.calculate(1.0 - x)),
    easeInOutBounce(x -> x < 0.5 ? (1.0 - easeOutBounce.calculate(1.0 - 2.0 * x)) / 2.0 : (1.0 + easeOutBounce.calculate(2.0 * x - 1.0)) / 2.0);

    private final DoubleUnaryOperator equation;

    private EasingFunctions(DoubleUnaryOperator equation) {
        this.equation = equation;
    }

    public double calculate(double x) {
        return this.equation.applyAsDouble(x);
    }
}

