/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.process.handler.indicator;

import com.hyfata.najoan.koreanpatch.data.ConfigManager;
import com.hyfata.najoan.koreanpatch.data.config.category.indicator.IndicatorAnimationConfig;
import org.lwjgl.glfw.GLFW;

public class AnimationHandler {
    private final float[] savedTargetPos = new float[2];
    private final float[] startPos = new float[2];
    private final float[] savedTime = new float[2];
    private final float[] resultPos = new float[2];
    private boolean init = false;

    public void init(float currentX, float currentY) {
        if (!this.init) {
            this.init = true;
            float[] current = new float[]{currentX, currentY};
            for (int i = 0; i < 2; ++i) {
                this.savedTargetPos[i] = current[i];
                this.startPos[i] = current[i];
                this.savedTime[i] = (float)GLFW.glfwGetTime();
                this.resultPos[i] = current[i];
            }
        }
    }

    public void calculateAnimation(float targetX, float targetY) {
        IndicatorAnimationConfig animation = ConfigManager.getInstance().getConfig().getCategoryIndicator().getAnimationSettings();
        float[] target = new float[]{targetX, targetY};
        float animationDuration = 1.0f - (float)animation.getSpeed() / 100.0f;
        if (!animation.isShowAnimation()) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            if (target[i] != this.savedTargetPos[i]) {
                this.savedTargetPos[i] = target[i];
                this.startPos[i] = this.resultPos[i];
                this.savedTime[i] = (float)GLFW.glfwGetTime();
            }
            float elapsedTime = (float)(GLFW.glfwGetTime() - (double)this.savedTime[i]);
            if (animationDuration == 0.0f || elapsedTime > animationDuration) {
                this.resultPos[i] = target[i];
                continue;
            }
            float targetDistance = target[i] - this.startPos[i];
            float x = elapsedTime / animationDuration;
            this.resultPos[i] = this.startPos[i] + targetDistance * (float)animation.getEasingFunction().calculate(x);
        }
    }

    public float getResultX() {
        return this.resultPos[0];
    }

    public float getResultY() {
        return this.resultPos[1];
    }
}

