/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RenderUtil {
    private static final Minecraft client = Minecraft.getInstance();

    public static void drawCenteredText(GuiGraphics context, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawCenteredText(context, text, x, y, -1);
    }

    public static void drawCenteredText(GuiGraphics context, FormattedCharSequence text, float x, float y, int color) {
        Font textRenderer = RenderUtil.client.font;
        float textWidth = textRenderer.width(text);
        float xPosition = x - textWidth / 2.0f;
        Objects.requireNonNull(RenderUtil.client.font);
        float yPosition = y - 9.0f / 2.0f;
        RenderUtil.drawText(context, text, xPosition, yPosition, color);
    }

    public static void drawText(GuiGraphics context, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawText(context, text, x, y, -1);
    }

    public static void drawText(GuiGraphics context, FormattedCharSequence text, float x, float y, int color) {
        Font textRenderer = RenderUtil.client.font;
        Matrix4f matrix = context.pose().last().pose();
        MultiBufferSource.BufferSource vertexConsumers = context.bufferSource();
        RenderSystem.enableBlend();
        textRenderer.drawInBatch(text, x, y, color, false, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.disableBlend();
    }

    public static void fill(GuiGraphics context, float x1, float y1, float x2, float y2, int color) {
        float i;
        Matrix4f matrix = context.pose().last().pose();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        RenderSystem.enableBlend();
        VertexConsumer vertexConsumer = context.bufferSource().getBuffer(RenderType.gui());
        vertexConsumer.vertex(matrix, x1, y1, 0.0f).color(color).endVertex();
        vertexConsumer.vertex(matrix, x1, y2, 0.0f).color(color).endVertex();
        vertexConsumer.vertex(matrix, x2, y2, 0.0f).color(color).endVertex();
        vertexConsumer.vertex(matrix, x2, y1, 0.0f).color(color).endVertex();
        context.flush();
        RenderSystem.disableBlend();
    }

    public static void drawVertexCircleFrame(GuiGraphics context, float centerX, float centerY, float radius, int frameColor, float frameThickness, VertexDirection direction) {
        float innerRadius = radius - frameThickness;
        if (innerRadius < 0.0f) {
            throw new IllegalArgumentException("Frame thickness cannot be greater than the outer radius.");
        }
        int steps = 18;
        float angleStep = 1.5707964f / (float)steps;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.cos((float)angleStep);
        float sinDelta = Mth.sin((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, innerRadius, cos, sin, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, cos, sin, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    public static void drawVertexSuperellipseFrame(GuiGraphics context, float centerX, float centerY, float radiusX, float radiusY, float exponent, int frameColor, float frameThickness, VertexDirection direction) {
        int steps = 36;
        float angleStep = 1.5707964f / (float)steps;
        float correctedExponent = 2.0f / exponent;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.cos((float)angleStep);
        float sinDelta = Mth.sin((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float projX = (float)Math.pow(Mth.abs((float)cos), correctedExponent);
            float projY = (float)Math.pow(Mth.abs((float)sin), correctedExponent);
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX - frameThickness, radiusY - frameThickness, projX, projY, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX, radiusY, projX, projY, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radius, float projX, float projY, VertexDirection direction) {
        return RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, radius, projX, projY, direction);
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radiusX, float radiusY, float projX, float projY, VertexDirection direction) {
        float x;
        return new float[]{x, switch (direction) {
            case VertexDirection.TOP_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.TOP_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.BOTTOM_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY + radiusY * projY;
            }
            case VertexDirection.BOTTOM_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY + radiusY * projY;
            }
            default -> throw new IllegalArgumentException("Invalid VertexDirection");
        }};
    }

    public static enum VertexDirection {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

