/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.animation;

import com.hyfata.najoan.koreanpatch.util.animation.EasingFunctions;
import org.lwjgl.glfw.GLFW;

public class AnimationUtil {
    private static final float animationDuration = 0.7f;
    private final float[] savedIndicator = new float[2];
    private final float[] savedAnimatedIndicator = new float[2];
    private final float[] animatedIndicator = new float[2];
    private final float[] animationTickTime = new float[2];
    private float resultX;
    private float resultY;
    private boolean init = false;

    public void init(float x, float y) {
        if (!this.init) {
            this.init = true;
            float[] crd = new float[]{x, y};
            for (int i = 0; i < 2; ++i) {
                this.savedIndicator[i] = crd[i];
                this.savedAnimatedIndicator[i] = crd[i];
                this.animatedIndicator[i] = crd[i];
            }
        }
    }

    public void calculateAnimation(float targetX, float targetY) {
        float[] indicator = new float[]{targetX, targetY};
        for (int i = 0; i < 2; ++i) {
            if (indicator[i] != this.savedIndicator[i]) {
                this.savedIndicator[i] = indicator[i];
                this.animationTickTime[i] = (float)GLFW.glfwGetTime();
                this.savedAnimatedIndicator[i] = this.animatedIndicator[i];
            }
            if (GLFW.glfwGetTime() - (double)this.animationTickTime[i] > (double)0.7f) {
                this.savedAnimatedIndicator[i] = indicator[i];
                continue;
            }
            this.animatedIndicator[i] = this.savedAnimatedIndicator[i] + (indicator[i] - this.savedAnimatedIndicator[i]) * EasingFunctions.easeOutQuint((float)(GLFW.glfwGetTime() - (double)this.animationTickTime[i]) / 0.7f);
            indicator[i] = this.animatedIndicator[i];
        }
        this.resultX = indicator[0];
        this.resultY = indicator[1];
    }

    public float getResultX() {
        return this.resultX;
    }

    public float getResultY() {
        return this.resultY;
    }
}

