/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.handler.mixin.common;

import com.hyfata.najoan.koreanpatch.handler.mixin.common.IMixinCommon;
import com.hyfata.najoan.koreanpatch.util.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.language.HangulProcessor;
import com.hyfata.najoan.koreanpatch.util.language.HangulUtil;

public class MixinCommonHandler {
    public static boolean onBackspaceKeyPressed(IMixinCommon mixinCommon, int cursorPosition, String text) {
        if (cursorPosition == 0 || cursorPosition != KeyboardLayout.INSTANCE.assemblePosition) {
            return false;
        }
        char ch = text.toCharArray()[cursorPosition - 1];
        if (HangulProcessor.isHangulSyllables(ch)) {
            int code = ch - 44032;
            int cho = code / 588;
            int jung = code % 588 / 28;
            int jong = code % 588 % 28;
            if (jong != 0) {
                char[] ch_arr = KeyboardLayout.INSTANCE.jongsung_ref_table.get(jong).toCharArray();
                jong = ch_arr.length == 2 ? KeyboardLayout.INSTANCE.jongsung_table.indexOf(ch_arr[0]) : 0;
                char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                mixinCommon.modifyText(c);
            } else {
                char[] ch_arr = KeyboardLayout.INSTANCE.jungsung_ref_table.get(jung).toCharArray();
                if (ch_arr.length == 2) {
                    jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(ch_arr[0]);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    mixinCommon.modifyText(c);
                } else {
                    char c = KeyboardLayout.INSTANCE.chosung_table.charAt(cho);
                    mixinCommon.modifyText(c);
                }
            }
            return true;
        }
        if (HangulProcessor.isHangulCharacter(ch)) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return false;
        }
        return false;
    }

    public static boolean onHangulCharTyped(IMixinCommon common, int keyCode, int modifiers, String text, boolean selectedTextEmpty) {
        int idx = HangulUtil.getFixedQwertyIndex(keyCode, modifiers);
        if (idx == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return false;
        }
        int cursorPosition = common.getCursor();
        char prev = text.toCharArray()[cursorPosition - 1];
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[idx];
        if (cursorPosition == KeyboardLayout.INSTANCE.assemblePosition && selectedTextEmpty) {
            if (HangulProcessor.isJaeum(prev) && HangulProcessor.isMoeum(curr)) {
                int cho = KeyboardLayout.INSTANCE.chosung_table.indexOf(prev);
                int jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                common.modifyText(c);
                KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
                return true;
            }
            if (HangulProcessor.isHangulSyllables(prev)) {
                int code = prev - 44032;
                int cho = code / 588;
                int jung = code % 588 / 28;
                int jong = code % 588 % 28;
                if (jong == 0 && HangulProcessor.isJungsung(prev, curr)) {
                    jung = HangulProcessor.getJungsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    common.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
                    return true;
                }
                if (jong == 0 && HangulProcessor.isJongsung(curr)) {
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, HangulProcessor.getJongsung(curr));
                    common.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJongsung(prev, curr)) {
                    jong = HangulProcessor.getJongsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    common.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJungsung(curr)) {
                    int newCho;
                    char[] tbl = KeyboardLayout.INSTANCE.jongsung_ref_table.get(jong).toCharArray();
                    if (tbl.length == 2) {
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf(tbl[1]);
                        jong = KeyboardLayout.INSTANCE.jongsung_table.indexOf(tbl[0]);
                    } else {
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf(KeyboardLayout.INSTANCE.jongsung_table.charAt(jong));
                        jong = 0;
                    }
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    common.modifyText(c);
                    cho = newCho;
                    jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                    code = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    common.writeText(String.valueOf(Character.toChars(code)));
                    KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
                    return true;
                }
            }
        }
        common.writeText(String.valueOf(curr));
        KeyboardLayout.INSTANCE.assemblePosition = common.getCursor();
        return true;
    }
}

