/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public class RenderUtil {
    private static final class_310 client = class_310.method_1551();

    public static void drawCenteredText(class_4587 context, class_5481 text, float x, float y) {
        RenderUtil.drawCenteredText(context, text, x, y, -1);
    }

    public static void drawCenteredText(class_4587 context, class_5481 text, float x, float y, int color) {
        class_327 textRenderer = RenderUtil.client.field_1772;
        float textWidth = textRenderer.method_30880(text);
        float xPosition = x - textWidth / 2.0f;
        Objects.requireNonNull(RenderUtil.client.field_1772);
        float yPosition = y - 9.0f / 2.0f;
        RenderUtil.drawText(context, text, xPosition, yPosition, color);
    }

    public static void drawText(class_4587 context, class_5481 text, float x, float y) {
        RenderUtil.drawText(context, text, x, y, -1);
    }

    public static void drawText(class_4587 context, class_5481 text, float x, float y, int color) {
        class_327 textRenderer = RenderUtil.client.field_1772;
        RenderSystem.enableBlend();
        textRenderer.method_27528(context, text, x, y, color);
        RenderSystem.disableBlend();
    }

    public static void fill(class_4587 context, float x1, float y1, float x2, float y2, int color) {
        float i;
        class_1159 matrix = context.method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x1, y1, 0.0f).method_39415(color).method_1344();
        bufferBuilder.method_22918(matrix, x1, y2, 0.0f).method_39415(color).method_1344();
        bufferBuilder.method_22918(matrix, x2, y2, 0.0f).method_39415(color).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, 0.0f).method_39415(color).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void drawVertexCircleFrame(class_4587 context, float centerX, float centerY, float radius, int frameColor, float frameThickness, VertexDirection direction) {
        float innerRadius = radius - frameThickness;
        if (innerRadius < 0.0f) {
            throw new IllegalArgumentException("Frame thickness cannot be greater than the outer radius.");
        }
        int steps = 18;
        float angleStep = 1.5707964f / (float)steps;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = class_3532.method_15362((float)angleStep);
        float sinDelta = class_3532.method_15374((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, innerRadius, cos, sin, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, cos, sin, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    public static void drawVertexSuperellipseFrame(class_4587 context, float centerX, float centerY, float radiusX, float radiusY, float exponent, int frameColor, float frameThickness, VertexDirection direction) {
        int steps = 36;
        float angleStep = 1.5707964f / (float)steps;
        float correctedExponent = 2.0f / exponent;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = class_3532.method_15362((float)angleStep);
        float sinDelta = class_3532.method_15374((float)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float projX = (float)Math.pow(class_3532.method_15379((float)cos), correctedExponent);
            float projY = (float)Math.pow(class_3532.method_15379((float)sin), correctedExponent);
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX - frameThickness, radiusY - frameThickness, projX, projY, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX, radiusY, projX, projY, direction);
            RenderUtil.fill(context, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radius, float projX, float projY, VertexDirection direction) {
        return RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, radius, projX, projY, direction);
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radiusX, float radiusY, float projX, float projY, VertexDirection direction) {
        float x;
        return new float[]{x, switch (direction) {
            case VertexDirection.TOP_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.TOP_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case VertexDirection.BOTTOM_LEFT -> {
                x = centerX - radiusX * projX;
                yield centerY + radiusY * projY;
            }
            case VertexDirection.BOTTOM_RIGHT -> {
                x = centerX + radiusX * projX;
                yield centerY + radiusY * projY;
            }
            default -> throw new IllegalArgumentException("Invalid VertexDirection");
        }};
    }

    public static enum VertexDirection {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

