/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.storage;

import com.hyfata.najoan.koreanpatch.client.Constants;
import com.hyfata.najoan.koreanpatch.driver.InputManager;
import com.hyfata.najoan.koreanpatch.process.LangTypeManager;
import com.hyfata.najoan.koreanpatch.process.LanguageType;
import com.hyfata.najoan.koreanpatch.storage.InputStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class InputStatusStorage {
    private static InputStatusStorage instance;
    private final File STATUS_FILE;
    private final Map<String, InputStatus> statusMap;

    public InputStatusStorage() {
        this.STATUS_FILE = new File(class_310.method_1551().field_1697, "koreanpatch.bin");
        this.statusMap = new HashMap<String, InputStatus>();
    }

    public static InputStatusStorage getInstance() {
        if (instance == null) {
            instance = new InputStatusStorage();
        }
        return instance;
    }

    public void add(class_437 screen) {
        this.add(screen, LangTypeManager.getInstance().getCurrentType(), InputManager.getController().isFocused());
    }

    public void add(class_437 screen, LanguageType languageType, boolean imeFocus) {
        if (screen == null) {
            return;
        }
        String screenName = screen.getClass().getName();
        if (this.statusMap.containsKey(screenName)) {
            InputStatus status = this.statusMap.get(screenName);
            status.setLanguageType(languageType);
            status.setImeFocus(imeFocus);
        } else {
            InputStatus status = new InputStatus(languageType, imeFocus);
            this.statusMap.put(screenName, status);
        }
    }

    public InputStatus get(class_437 screen) {
        if (screen == null) {
            return null;
        }
        return this.statusMap.get(screen.getClass().getName());
    }

    public void save() {
        try (FileOutputStream fos = new FileOutputStream(this.STATUS_FILE);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(this.statusMap);
            oos.flush();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save input status file: {}", (Object)this.STATUS_FILE, (Object)e);
        }
    }

    public void load() {
        if (!this.STATUS_FILE.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(this.STATUS_FILE);
             ObjectInputStream ois = new ObjectInputStream(fis);){
            this.statusMap.clear();
            this.statusMap.putAll((Map)ois.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            Constants.LOG.error("Failed to load input status file: {}", (Object)this.STATUS_FILE, (Object)e);
        }
    }
}

