/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.client;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.ime.controller.InputManager;
import com.hyfata.najoan.koreanpatch.util.ReflectionFieldChecker;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CartographyTableScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.JigsawBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.inventory.StructureBlockEditScreen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;

public class EventListener {
    private static ArrayList<Class<?>> patchedScreenClazz = new ArrayList();

    public static void onClientStarted() {
        KoreanPatchClient.clientStarted();
        String[] imeDisabledScreens = new String[]{"arm32x.minecraft.commandblockide.client.gui.screen.CommandIDEScreen", "xaero.map.gui.GuiMap"};
        Class[] imeDisabledClasses = new Class[]{KeyBindsScreen.class, ContainerScreen.class, InventoryScreen.class, FurnaceScreen.class, CraftingScreen.class, EnchantmentScreen.class, BeaconScreen.class, ShulkerBoxScreen.class, SmokerScreen.class, CartographyTableScreen.class, BlastFurnaceScreen.class, SmithingScreen.class, GrindstoneScreen.class, BrewingStandScreen.class, LoomScreen.class, StonecutterScreen.class, MerchantScreen.class};
        patchedScreenClazz = EventListener.getExistingClasses(imeDisabledScreens);
        patchedScreenClazz.addAll(Arrays.asList(imeDisabledClasses));
    }

    public static void afterScreenChange() {
        Minecraft client = Minecraft.getInstance();
        if (client.screen != null) {
            Class[] bypassScreens = new Class[]{JigsawBlockEditScreen.class, StructureBlockEditScreen.class};
            KoreanPatchClient.bypassInjection = Arrays.stream(bypassScreens).anyMatch(cls -> cls.isInstance(client.screen));
            boolean screenPatched = false;
            for (Class<?> cls2 : patchedScreenClazz) {
                if (!cls2.isInstance(client.screen)) continue;
                screenPatched = true;
                break;
            }
            if (InputManager.getController() != null) {
                if (!screenPatched) {
                    boolean hasTextFieldWidget = ReflectionFieldChecker.hasFieldOfType(client.screen, EditBox.class);
                    boolean hasSelectionManager = ReflectionFieldChecker.hasFieldOfType(client.screen, TextFieldHelper.class);
                    InputManager.getController().setFocus(!hasTextFieldWidget && !hasSelectionManager);
                } else {
                    InputManager.getController().setFocus(false);
                }
            }
        }
    }

    public static void onClientTick() {
        Minecraft client = Minecraft.getInstance();
        if (InputManager.getController() == null) {
            return;
        }
        if (client.screen == null && !KoreanPatchClient.axiomEditorUIOpened) {
            InputManager.getController().setFocus(false);
        } else if (KoreanPatchClient.axiomEditorUIOpened) {
            InputManager.getController().setFocus(true);
        }
    }

    private static ArrayList<Class<?>> getExistingClasses(String[] clazz) {
        ArrayList result = new ArrayList();
        for (String className : clazz) {
            try {
                Class<?> cls = Class.forName(className);
                result.add(cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }
}

