/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.handler.mixin;

import com.hyfata.najoan.koreanpatch.handler.mixin.common.IMixinCommon;
import com.hyfata.najoan.koreanpatch.handler.mixin.common.MixinCommonHandler;
import com.hyfata.najoan.koreanpatch.util.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.language.HangulProcessor;
import com.hyfata.najoan.koreanpatch.util.language.HangulUtil;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class REITextFieldHandler
implements IMixinCommon {
    private final TextField accessor;

    public REITextFieldHandler(TextField accessor) {
        this.accessor = accessor;
    }

    @Override
    public int getCursor() {
        return this.accessor.getCursor();
    }

    @Override
    public void writeText(String str) {
        this.accessor.addText(str);
    }

    @Override
    public void modifyText(char ch) {
        Object text = this.accessor.getText();
        text = ((String)text).substring(0, ((String)text).length() - 1) + ch;
        this.accessor.setText((String)text);
    }

    public boolean onBackspaceKeyPressed() {
        if (!this.accessor.getSelectedText().isEmpty()) {
            return false;
        }
        int cursorPosition = this.accessor.getCursor();
        return MixinCommonHandler.onBackspaceKeyPressed(this, cursorPosition, this.accessor.getText());
    }

    public boolean onHangulCharTyped(int keyCode, int modifiers) {
        return MixinCommonHandler.onHangulCharTyped(this, keyCode, modifiers, this.accessor.getText(), this.accessor.getSelectedText().isEmpty());
    }

    public void typedTextField(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
        if (qwertyIndex == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return;
        }
        if (!this.accessor.isFocused()) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        cir.setReturnValue((Object)Boolean.TRUE);
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
        if (this.getCursor() == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }
}

