/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.handler;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.config.indicator.CategoryIndicator;
import com.hyfata.najoan.koreanpatch.config.indicator.ColorOpacityConfig;
import com.hyfata.najoan.koreanpatch.config.indicator.outline.Outline;
import com.hyfata.najoan.koreanpatch.util.language.LanguageUtil;
import com.hyfata.najoan.koreanpatch.util.minecraft.RenderUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Indicator {
    private static final Minecraft client = Minecraft.m_91087_();
    private static final float frame = 1.0f;
    private static final float margin = 1.0f;

    public static void showIndicator(GuiGraphics context, float x, float y) {
        CategoryIndicator categoryIndicator = KoreanPatchClient.config.getCategoryIndicator();
        if (!categoryIndicator.isShowIndicator()) {
            return;
        }
        float width = LanguageUtil.getCurrentTextWidth();
        Objects.requireNonNull(Indicator.client.f_91062_);
        float height = 9.0f;
        Indicator.renderBox(context, x, y, x + 1.0f + width + 2.0f, y + 1.0f + height + 2.0f, Indicator.getARGB(categoryIndicator.getOutlineSettings().getColorOpacitySettings()), Indicator.getARGB(categoryIndicator.getBackgroundSettings()));
        RenderUtil.drawCenteredText(context, LanguageUtil.getCurrentText(), x + 1.0f + width / 2.0f + 1.0f, y + 1.0f + height / 2.0f + 1.0f, Indicator.getARGB(categoryIndicator.getTextSettings()));
    }

    public static void showIndicator(GuiGraphics context, int x, int y) {
        Indicator.showIndicator(context, (float)x, (float)y);
    }

    public static void showCenteredIndicator(GuiGraphics context, float x, float y) {
        Indicator.showIndicator(context, x -= Indicator.getIndicatorWidth() / 2.0f, y -= Indicator.getIndicatorHeight() / 2.0f);
    }

    public static void showCenteredIndicator(GuiGraphics context, int x, int y) {
        Indicator.showCenteredIndicator(context, (float)x, (float)y);
    }

    public static float getIndicatorWidth() {
        return 1.0f + (float)LanguageUtil.getCurrentTextWidth() + 2.0f;
    }

    public static float getIndicatorHeight() {
        Objects.requireNonNull(Indicator.client.f_91062_);
        return 1.0f + 9.0f + 2.0f;
    }

    private static int getARGB(ColorOpacityConfig colorOpacityConfig) {
        int outlineRGB = KoreanPatchClient.IME ? colorOpacityConfig.getImeColor() : (LanguageUtil.isKorean() ? colorOpacityConfig.getKoreanColor() : colorOpacityConfig.getEnColor());
        int outlineOpacity = colorOpacityConfig.getOpacity() * 255 / 100;
        return (outlineOpacity & 0xFF) << 24 | outlineRGB;
    }

    private static void renderBox(GuiGraphics context, float x1, float y1, float x2, float y2, int frameColor, int backgroundColor) {
        Outline outline = KoreanPatchClient.config.getCategoryIndicator().getOutlineSettings();
        float radius = outline.isRounded() ? 3.5f : 0.0f;
        float adjustment = outline.isRounded() ? 0.65f : 0.0f;
        RenderUtil.fill(context, x1 + 1.0f, y1 + 1.0f, x2 - 1.0f, y2 - 1.0f, backgroundColor);
        if (outline.isShowOutline()) {
            if (outline.isRounded()) {
                RenderUtil.drawVertexCircleFrame(context, x1 + radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_LEFT);
                RenderUtil.drawVertexCircleFrame(context, x2 - radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_RIGHT);
                RenderUtil.drawVertexCircleFrame(context, x1 + radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_LEFT);
                RenderUtil.drawVertexCircleFrame(context, x2 - radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_RIGHT);
            }
            RenderUtil.fill(context, x1 + radius - adjustment, y1, x2 - radius + adjustment, y1 + 1.0f, frameColor);
            RenderUtil.fill(context, x1 + radius - adjustment, y2, x2 - radius + adjustment, y2 - 1.0f, frameColor);
            RenderUtil.fill(context, x1, y1 + radius - adjustment, x1 + 1.0f, y2 - radius + adjustment, frameColor);
            RenderUtil.fill(context, x2, y1 + radius - adjustment, x2 - 1.0f, y2 - radius + adjustment, frameColor);
        }
    }
}

