/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.config.gson;

import com.google.gson.Gson;
import com.hyfata.najoan.koreanpatch.config.gson.JsonComment;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonCommentProcessor {
    private final Gson gson;

    public JsonCommentProcessor(Gson gson) {
        this.gson = gson;
    }

    public <T> T readWithoutComments(Reader reader, Class<T> type) throws IOException {
        int ch;
        StringBuilder builder = new StringBuilder();
        while ((ch = reader.read()) != -1) {
            builder.append((char)ch);
        }
        String cleaned = JsonCommentProcessor.stripComments(builder.toString());
        return (T)this.gson.fromJson(cleaned, type);
    }

    public static String stripComments(String json) {
        json = json.replaceAll("(?m)^\\s*//.*?$", "");
        json = json.replaceAll("(?s)/\\*.*?\\*/", "");
        return json;
    }

    public void writeWithComments(Object obj, Writer writer) throws IOException {
        this.writeObjectWithComments(obj, writer, 0, new IdentityHashMap<Object, Boolean>());
    }

    private void writeObjectWithComments(Object obj, Writer writer, int indent, Map<Object, Boolean> visited) throws IOException {
        if (this.handleSpecialCases(obj, writer, visited)) {
            return;
        }
        writer.write("{\n");
        int currentIndent = indent + 1;
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            Field field = this.getAccessibleField(fields[i]);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            this.writeComment(writer, currentIndent, field);
            this.write(writer, currentIndent, "\"" + field.getName() + "\": ");
            this.writeObjectWithComments(value, writer, currentIndent, visited);
            if (i < fields.length - 1) {
                writer.write(",");
            }
            writer.write("\n");
        }
        this.write(writer, indent, "}");
        visited.remove(obj);
    }

    private boolean handleSpecialCases(Object obj, Writer writer, Map<Object, Boolean> visited) throws IOException {
        if (obj == null) {
            writer.write("null");
            return true;
        }
        if (this.isPrimitive(obj) || obj.getClass().isEnum() || this.isJavaClass(obj.getClass())) {
            this.gson.toJson(obj, (Appendable)writer);
            return true;
        }
        if (visited.containsKey(obj)) {
            writer.write("\"<circular>\"");
            return true;
        }
        visited.put(obj, true);
        return false;
    }

    private void writeComment(Writer writer, int indent, Field field) throws IOException {
        JsonComment comment = field.getAnnotation(JsonComment.class);
        if (comment != null) {
            ?[] enumConstants;
            this.writeIndent(writer, indent);
            StringBuilder commentLine = new StringBuilder("// " + comment.value());
            if (comment.enums() && field.getType().isEnum() && (enumConstants = field.getType().getEnumConstants()) != null) {
                String enumList = Arrays.stream(enumConstants).map(Object::toString).collect(Collectors.joining(", "));
                commentLine.append("[").append(enumList).append("]");
            }
            writer.write(commentLine + "\n");
        }
    }

    private boolean isPrimitive(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> c = value.getClass();
        return c.isPrimitive() || c == String.class || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c);
    }

    private boolean isJavaClass(Class<?> clazz) {
        return clazz.getPackage() != null && clazz.getPackage().getName().startsWith("java");
    }

    private void writeIndent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write("  ");
        }
    }

    private void write(Writer writer, int indent, String str) throws IOException {
        this.writeIndent(writer, indent);
        writer.write(str);
    }

    private Field getAccessibleField(Field field) {
        field.setAccessible(true);
        return field;
    }
}

