/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.driver.arch.darwin;

import com.hyfata.najoan.koreanpatch.client.Constants;
import com.hyfata.najoan.koreanpatch.config.ConfigManager;
import com.hyfata.najoan.koreanpatch.driver.InputController;
import com.hyfata.najoan.koreanpatch.driver.arch.darwin.DarwinHandle;
import com.sun.jna.Library;
import com.sun.jna.Native;

public class DarwinController
implements InputController {
    private boolean focus = false;
    private boolean fakeFocus = false;
    private static final long kCGEventFlagMaskAlphaShift = 65536L;
    private static final int kCGEventSourceStateHIDSystemState = 0;

    public DarwinController() {
        DarwinHandle.LogInfoCallback info = log -> Constants.LOG.info("[Native|C] {}", (Object)log);
        DarwinHandle.LogErrorCallback error = log -> Constants.LOG.error("[Native|C] {}", (Object)log);
        DarwinHandle.LogDebugCallback debug = log -> Constants.LOG.debug("[Native|C] {}", (Object)log);
        DarwinHandle.INSTANCE.initialize(info, error, debug);
    }

    public boolean isCapsLockOn() {
        try {
            long flags = CoreGraphics.INSTANCE.CGEventSourceFlagsState(0);
            return (flags & 0x10000L) != 0L;
        }
        catch (Exception e) {
            Constants.LOG.debug("Failed to get Caps Lock state: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void setFocus(boolean focus) {
        boolean alwaysIme = ConfigManager.getInstance().getConfig().getCategoryInput().isAlwaysImeEnabled();
        if (!alwaysIme && !this.fakeFocus && this.focus == focus) {
            return;
        }
        this.focus = focus;
        if (alwaysIme) {
            if (this.fakeFocus) {
                return;
            }
            focus = true;
            this.fakeFocus = true;
        } else if (this.fakeFocus) {
            this.fakeFocus = false;
            if (focus) {
                return;
            }
        }
        DarwinHandle.INSTANCE.setFocused(focus ? 1 : 0);
    }

    @Override
    public void toggleFocus() {
        this.setFocus(!this.focus);
    }

    @Override
    public boolean isFocused() {
        return this.focus;
    }

    public static interface CoreGraphics
    extends Library {
        public static final CoreGraphics INSTANCE = (CoreGraphics)Native.load((String)"CoreGraphics", CoreGraphics.class);

        public long CGEventSourceFlagsState(int var1);
    }
}

