/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util;

import com.hyfata.najoan.koreanpatch.client.Constants;
import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;

public class LibraryUtil {
    public static String copyLibrary(String name) {
        try {
            URL url = KoreanPatchClient.class.getClassLoader().getResource("native/" + name);
            if (url == null) {
                throw new IOException("Native library (" + name + ") not found.");
            }
            File lib = File.createTempFile("koreanpatch", Platform.isWindows() ? ".dll" : null, LibraryUtil.tempDir());
            try (InputStream is = url.openStream();
                 FileOutputStream fos = new FileOutputStream(lib);){
                Constants.LOG.debug("Extracting library to {}", (Object)lib.getAbsolutePath());
                fos.write(is.readAllBytes());
                lib.deleteOnExit();
            }
            Constants.LOG.info("{} has copied library to native directory.", (Object)name);
            return lib.getAbsolutePath();
        }
        catch (Exception exception) {
            Constants.LOG.error("An error occurred while loading the library.");
            throw new RuntimeException(exception);
        }
    }

    private static File tempDir() throws IOException {
        try {
            Method method = Native.class.getDeclaredMethod("getTempDir", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return File.createTempFile("native", "temp");
        }
    }
}

