/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.process.controller.mixin;

import com.hyfata.najoan.koreanpatch.data.LangTypeManager;
import com.hyfata.najoan.koreanpatch.data.provider.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.mixin.accessor.TextFieldHelperAccessor;
import com.hyfata.najoan.koreanpatch.process.controller.mixin.common.IMixinCommon;
import com.hyfata.najoan.koreanpatch.process.controller.mixin.common.MixinCommonController;
import com.hyfata.najoan.koreanpatch.process.handler.hangul.HangulProcessor;
import com.hyfata.najoan.koreanpatch.util.HangulUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TextFieldHelperController
implements IMixinCommon {
    private final TextFieldHelperAccessor accessor;
    private final Minecraft client = Minecraft.getInstance();

    public TextFieldHelperController(TextFieldHelperAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void modifyText(char ch) {
        int cursorPosition = this.accessor.getCursor();
        char[] arr = this.getText().toCharArray();
        if (cursorPosition > 0 && cursorPosition <= arr.length) {
            arr[cursorPosition - 1] = ch;
            this.setText(String.valueOf(arr));
        }
    }

    @Override
    public int getCursor() {
        return this.accessor.getCursor();
    }

    @Override
    public void writeText(String str) {
        this.accessor.runInsert(this.getText(), str);
    }

    public boolean onBackspaceKeyPressed() {
        return MixinCommonController.onBackspaceKeyPressed(this, this.getCursor(), this.getText());
    }

    public int getModifiers() {
        boolean shift;
        boolean bl = shift = InputConstants.isKeyDown((long)this.client.getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)this.client.getWindow().getWindow(), (int)344);
        if (shift) {
            return 1;
        }
        return 0;
    }

    public String getText() {
        return this.accessor.getStringGetter().get();
    }

    public void setText(String str) {
        if (this.accessor.getStringFilter().test(str)) {
            this.accessor.getStringSetter().accept(str);
        }
    }

    public boolean onHangulCharTyped(int keyCode, int modifiers) {
        String text = this.getText();
        if (text.isEmpty()) {
            return false;
        }
        return MixinCommonController.onHangulCharTyped(this, keyCode, modifiers, text, this.accessor.selectedText(text).isEmpty());
    }

    public void insertChar(char chr, CallbackInfoReturnable<Boolean> cir) {
        if (this.client.screen != null && LangTypeManager.getInstance().isKorean()) {
            cir.setReturnValue((Object)Boolean.TRUE);
            if (chr == ' ') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.getCursor() : -1;
                return;
            }
            int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                return;
            }
            Objects.requireNonNull(KeyboardLayout.INSTANCE);
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.getCursor();
            int modifiers = this.getModifiers();
            if (cursorPosition == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
                this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
            }
        }
    }

    public void insertString(String string, CallbackInfo ci) {
        boolean colored = false;
        for (char chr : string.toCharArray()) {
            if (this.client.screen == null || !LangTypeManager.getInstance().isKorean()) continue;
            ci.cancel();
            if (chr == ' ' || chr == '\n') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.getCursor() : -1;
                continue;
            }
            if (chr == '\u00a7') {
                this.writeText(String.valueOf(chr));
                colored = true;
                continue;
            }
            if (colored) {
                this.writeText(String.valueOf(chr));
                colored = false;
                continue;
            }
            int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                continue;
            }
            Objects.requireNonNull(KeyboardLayout.INSTANCE);
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.getCursor();
            int modifiers = this.getModifiers();
            if (cursorPosition != 0 && HangulProcessor.isHangulCharacter(curr) && this.onHangulCharTyped(chr, modifiers)) continue;
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }
}

