/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hyfata.najoan.koreanpatch.client.Constants;
import com.hyfata.najoan.koreanpatch.config.EasingFunctions;
import com.hyfata.najoan.koreanpatch.config.ModConfig;
import com.hyfata.najoan.koreanpatch.config.OutlineType;
import com.hyfata.najoan.koreanpatch.config.gson.JsonCommentProcessor;
import com.hyfata.najoan.koreanpatch.config.gson.adapter.ColorAdapter;
import com.hyfata.najoan.koreanpatch.config.gson.adapter.EasingFunctionsAdapter;
import com.hyfata.najoan.koreanpatch.config.gson.adapter.OutlineTypeAdapter;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.class_156;
import net.minecraft.class_310;

public class ConfigManager {
    private static ConfigManager instance;
    private static final String CONFIG_FILE_NAME = "koreanpatch.json5";
    private ModConfig config = new ModConfig();
    private File CONFIG_FILE;

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    private Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorAdapter()).registerTypeAdapter(EasingFunctions.class, (Object)new EasingFunctionsAdapter()).registerTypeAdapter(OutlineType.class, (Object)new OutlineTypeAdapter()).setPrettyPrinting().create();
    }

    public void init() {
        this.CONFIG_FILE = class_310.method_1551().field_1697.toPath().resolve("config").resolve(CONFIG_FILE_NAME).toFile();
        if (!this.CONFIG_FILE.getParentFile().exists()) {
            boolean bl = this.CONFIG_FILE.getParentFile().mkdirs();
        }
        if (this.CONFIG_FILE.exists()) {
            this.loadFromFile();
        }
        this.saveConfig(this.config);
    }

    private void loadFromFile() {
        try (FileReader reader = new FileReader(this.CONFIG_FILE);){
            JsonCommentProcessor processor = new JsonCommentProcessor(this.createGson());
            this.config = processor.readWithoutComments(reader, ModConfig.class);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to read config file: {}", (Object)this.CONFIG_FILE.toString(), (Object)e);
        }
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void saveConfig(ModConfig config) {
        this.config = config;
        try (FileWriter writer = new FileWriter(this.CONFIG_FILE);){
            JsonCommentProcessor commentedWriter = new JsonCommentProcessor(this.createGson());
            commentedWriter.writeWithComments(config, writer);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to write config file: {}", (Object)this.CONFIG_FILE.toString(), (Object)e);
        }
    }

    public void openConfigFile() {
        class_156.method_668().method_672(this.CONFIG_FILE);
    }
}

