/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.process;

import com.hyfata.najoan.koreanpatch.config.ConfigManager;
import com.hyfata.najoan.koreanpatch.driver.InputManager;
import com.hyfata.najoan.koreanpatch.process.LanguageType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class LangTypeManager {
    private static LangTypeManager instance;
    private final Minecraft client = Minecraft.getInstance();
    private LanguageType currentType = LanguageType.EN;
    private final Component IME_TEXT = Component.literal((String)"IME");

    public static LangTypeManager getInstance() {
        if (instance == null) {
            instance = new LangTypeManager();
        }
        return instance;
    }

    public void setCurrentType(LanguageType type) {
        this.currentType = type;
    }

    public LanguageType getCurrentType() {
        return this.currentType;
    }

    public boolean isKorean() {
        if (!ConfigManager.getInstance().getConfig().getCategoryInput().isAlwaysImeEnabled()) {
            return this.currentType == LanguageType.KO && !InputManager.getController().isFocused();
        }
        return this.currentType == LanguageType.KO;
    }

    public void toggleCurrentType() {
        this.currentType = this.currentType == LanguageType.KO ? LanguageType.EN : LanguageType.KO;
    }

    public FormattedCharSequence getCurrentText() {
        if (InputManager.getController().isFocused() && !ConfigManager.getInstance().getConfig().getCategoryInput().isAlwaysImeEnabled()) {
            return this.IME_TEXT.getVisualOrderText();
        }
        return this.currentType.getTranslatedVisualOrderText();
    }

    public int getCurrentTextWidth() {
        return this.client.font.width(this.getCurrentText());
    }
}

