/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.client;

import com.hyfata.najoan.koreanpatch.client.EventListener;
import com.hyfata.najoan.koreanpatch.client.KeyBinds;
import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.config.ModConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="koreanpatch", dist={Dist.CLIENT})
public class KoreanPatchNeoForge {
    public KoreanPatchNeoForge(IEventBus bus, ModContainer container) {
        this.registerConfig();
        KoreanPatchClient.init();
        bus.addListener(this::registerKeys);
        this.registerEvents(bus);
    }

    public void registerConfig() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (container, parent) -> (Screen)AutoConfig.getConfigScreen(ModConfig.class, (Screen)parent).get());
    }

    public void registerEvents(IEventBus bus) {
        bus.addListener(KoreanPatchNeoForge::onClientStarted);
        NeoForge.EVENT_BUS.addListener(KoreanPatchNeoForge::onClientTick);
        NeoForge.EVENT_BUS.addListener(KoreanPatchNeoForge::afterScreenChange);
    }

    @SubscribeEvent
    public void registerKeys(RegisterKeyMappingsEvent event) {
        for (KeyMapping key : KeyBinds.getKeyMappings()) {
            event.register(key);
        }
    }

    @SubscribeEvent
    public static void onClientStarted(FMLClientSetupEvent event) {
        EventListener.onClientStarted();
    }

    @SubscribeEvent
    public static void afterScreenChange(ScreenEvent.Init.Post event) {
        EventListener.afterScreenChange();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        EventListener.onClientTick();
    }
}

