/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.handler;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.util.language.LanguageUtil;
import com.hyfata.najoan.koreanpatch.util.minecraft.RenderUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Indicator {
    private static final Minecraft client = Minecraft.getInstance();
    private static final float frame = 1.0f;
    private static final float margin = 1.0f;

    public static void showIndicator(GuiGraphics context, float x, float y) {
        int rgb = 0;
        int backgroundOpacity = 127;
        int backgroundColor = (backgroundOpacity & 0xFF) << 24 | rgb;
        int frameColor = KoreanPatchClient.IME ? -1 : (LanguageUtil.isKorean() ? -65536 : -16711936);
        float width = LanguageUtil.getCurrentTextWidth();
        Objects.requireNonNull(Indicator.client.font);
        float height = 9.0f;
        Indicator.renderBox(context, x, y, x + 1.0f + width + 2.0f, y + 1.0f + height + 2.0f, frameColor, backgroundColor);
        RenderUtil.drawCenteredText(context, LanguageUtil.getCurrentText(), x + 1.0f + width / 2.0f + 1.0f, y + 1.0f + height / 2.0f + 1.0f);
    }

    public static void showIndicator(GuiGraphics context, int x, int y) {
        Indicator.showIndicator(context, (float)x, (float)y);
    }

    public static void showCenteredIndicator(GuiGraphics context, float x, float y) {
        Indicator.showIndicator(context, x -= Indicator.getIndicatorWidth() / 2.0f, y -= Indicator.getIndicatorHeight() / 2.0f);
    }

    public static void showCenteredIndicator(GuiGraphics context, int x, int y) {
        Indicator.showCenteredIndicator(context, (float)x, (float)y);
    }

    public static float getIndicatorWidth() {
        return 1.0f + (float)LanguageUtil.getCurrentTextWidth() + 2.0f;
    }

    public static float getIndicatorHeight() {
        Objects.requireNonNull(Indicator.client.font);
        return 1.0f + 9.0f + 2.0f;
    }

    private static void renderBox(GuiGraphics context, float x1, float y1, float x2, float y2, int frameColor, int backgroundColor) {
        float radius = 3.5f;
        float adjustment = 0.65f;
        RenderUtil.fill(context, x1 + 1.0f, y1 + 1.0f, x2 - 1.0f, y2 - 1.0f, backgroundColor);
        RenderUtil.drawVertexCircleFrame(context, x1 + radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_LEFT);
        RenderUtil.drawVertexCircleFrame(context, x2 - radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_RIGHT);
        RenderUtil.drawVertexCircleFrame(context, x1 + radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_LEFT);
        RenderUtil.drawVertexCircleFrame(context, x2 - radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_RIGHT);
        RenderUtil.fill(context, x1 + radius - adjustment, y1, x2 - radius + adjustment, y1 + 1.0f, frameColor);
        RenderUtil.fill(context, x1 + radius - adjustment, y2, x2 - radius + adjustment, y2 - 1.0f, frameColor);
        RenderUtil.fill(context, x1, y1 + radius - adjustment, x1 + 1.0f, y2 - radius + adjustment, frameColor);
        RenderUtil.fill(context, x2, y1 + radius - adjustment, x2 - 1.0f, y2 - radius + adjustment, frameColor);
    }
}

