/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.client;

import com.hyfata.najoan.koreanpatch.client.GUIStatus;
import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.config.ConfigManager;
import com.hyfata.najoan.koreanpatch.config.category.CategoryInput;
import com.hyfata.najoan.koreanpatch.config.category.input.AutoLangTypeMode;
import com.hyfata.najoan.koreanpatch.driver.InputController;
import com.hyfata.najoan.koreanpatch.driver.InputManager;
import com.hyfata.najoan.koreanpatch.process.LangTypeManager;
import com.hyfata.najoan.koreanpatch.process.LanguageType;
import com.hyfata.najoan.koreanpatch.storage.InputStatus;
import com.hyfata.najoan.koreanpatch.storage.InputStatusStorage;
import com.hyfata.najoan.koreanpatch.util.ReflectionFieldChecker;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3728;
import net.minecraft.class_3742;
import net.minecraft.class_3802;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3934;
import net.minecraft.class_3979;
import net.minecraft.class_437;
import net.minecraft.class_466;
import net.minecraft.class_472;
import net.minecraft.class_476;
import net.minecraft.class_479;
import net.minecraft.class_486;
import net.minecraft.class_4895;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.class_495;
import net.minecraft.class_497;
import net.minecraft.class_6599;

public class EventListener {
    private static ArrayList<Class<?>> patchedScreenClazz = new ArrayList();
    private static final Class<?>[] injectionBypassScreens = new Class[]{class_3742.class, class_497.class};

    public static void onClientStarted() {
        KoreanPatchClient.clientStarted();
        String[] imeDisabledScreens = new String[]{"arm32x.minecraft.commandblockide.client.gui.screen.CommandIDEScreen", "xaero.map.gui.GuiMap"};
        Class[] imeDisabledClasses = new Class[]{class_6599.class, class_476.class, class_490.class, class_3873.class, class_479.class, class_486.class, class_466.class, class_495.class, class_3874.class, class_3934.class, class_3871.class, class_4895.class, class_3802.class, class_472.class, class_494.class, class_3979.class, class_492.class};
        patchedScreenClazz = EventListener.getExistingClasses(imeDisabledScreens);
        patchedScreenClazz.addAll(Arrays.asList(imeDisabledClasses));
    }

    public static void afterScreenChange() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null || !KoreanPatchClient.loaded) {
            return;
        }
        GUIStatus.getInstance().setBypassInjection(EventListener.isInjectionBypassScreen(screen));
        boolean hasTextInput = EventListener.isScreenPatched(screen) || EventListener.hasTextField(screen);
        InputController controller = InputManager.getController();
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        if (controller != null && categoryInput.isAutoImeSwitch()) {
            controller.setFocus(!hasTextInput);
        }
        if (hasTextInput) {
            EventListener.setLangType(screen);
        }
    }

    public static void onClientTick() {
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        class_310 client = class_310.method_1551();
        if (client.field_1755 == null && !GUIStatus.getInstance().isShouldUseIME() && categoryInput.isDisableImeWhenPlaying()) {
            InputManager.getController().setFocus(false);
        } else if (GUIStatus.getInstance().isShouldUseIME()) {
            InputManager.getController().setFocus(true);
        }
    }

    private static void setLangType(class_437 screen) {
        CategoryInput categoryInput = ConfigManager.getInstance().getConfig().getCategoryInput();
        AutoLangTypeMode mode = categoryInput.getAutoLangTypeMode();
        if (mode != AutoLangTypeMode.AUTO) {
            switch (mode) {
                case KOREAN: {
                    LangTypeManager.getInstance().setCurrentType(LanguageType.KO);
                    break;
                }
                case ENGLISH: {
                    LangTypeManager.getInstance().setCurrentType(LanguageType.EN);
                    break;
                }
                case IME: {
                    InputManager.getController().setFocus(true);
                }
            }
        }
        if (categoryInput.isMemoryLangTypePerScreen()) {
            EventListener.setStoredLangType(screen);
        }
    }

    private static void setStoredLangType(class_437 screen) {
        InputStatus inputStatus = InputStatusStorage.getInstance().get(screen);
        if (inputStatus != null) {
            LangTypeManager.getInstance().setCurrentType(inputStatus.getLanguageType());
            InputManager.getController().setFocus(inputStatus.isImeFocus());
        } else {
            InputStatusStorage.getInstance().add(screen);
        }
        InputStatusStorage.getInstance().save();
    }

    private static ArrayList<Class<?>> getExistingClasses(String[] clazz) {
        ArrayList result = new ArrayList();
        for (String className : clazz) {
            try {
                Class<?> cls = Class.forName(className);
                result.add(cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isInjectionBypassScreen(class_437 screen) {
        return Arrays.stream(injectionBypassScreens).anyMatch(cls -> cls.isInstance(screen));
    }

    private static boolean isScreenPatched(class_437 screen) {
        boolean screenPatched = false;
        for (Class<?> cls : patchedScreenClazz) {
            if (!cls.isInstance(screen)) continue;
            screenPatched = true;
            break;
        }
        return screenPatched;
    }

    private static boolean hasTextField(class_437 screen) {
        boolean hasTextFieldWidget = ReflectionFieldChecker.hasFieldOfType(screen, class_342.class);
        boolean hasSelectionManager = ReflectionFieldChecker.hasFieldOfType(screen, class_3728.class);
        return hasTextFieldWidget || hasSelectionManager;
    }
}

