/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.wrapper;

import com.hyfata.najoan.koreanpatch.mixin.accessor.MultilineTextFieldAccessor;
import com.hyfata.najoan.koreanpatch.process.HangulProcessor;
import com.hyfata.najoan.koreanpatch.process.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.HangulUtil;
import com.hyfata.najoan.koreanpatch.wrapper.InterfaceIMEWrapper;
import com.hyfata.najoan.koreanpatch.wrapper.handler.IMEWrapperHandler;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WrapperMultilineTextField
implements InterfaceIMEWrapper {
    private final MultilineTextFieldAccessor accessor;

    public WrapperMultilineTextField(MultilineTextFieldAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public int getCursor() {
        return this.accessor.getCursor();
    }

    @Override
    public void writeText(String str) {
        this.accessor.invokeInsertText(str);
    }

    @Override
    public void modifyText(char ch) {
        this.accessor.invokeDeleteText(-1);
        this.writeText(String.valueOf(Character.toChars(ch)));
    }

    public boolean onBackspaceKeyPressed() {
        if (this.accessor.invokeHasSelection()) {
            return false;
        }
        int cursorPosition = this.getCursor();
        return IMEWrapperHandler.onBackspaceKeyPressed(this, cursorPosition, this.accessor.getValue());
    }

    public boolean onHangulCharTyped(int keyCode, int modifiers) {
        return IMEWrapperHandler.onHangulCharTyped(this, keyCode, modifiers, this.accessor.getValue(), !this.accessor.invokeHasSelection());
    }

    public void charTyped(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
        if (qwertyIndex == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return;
        }
        cir.setReturnValue((Object)Boolean.TRUE);
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
        if (this.getCursor() == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }
}

