/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stevesaga.fluid;

import net.mcreator.stevesaga.init.SteveModModBlocks;
import net.mcreator.stevesaga.init.SteveModModFluidTypes;
import net.mcreator.stevesaga.init.SteveModModFluids;
import net.mcreator.stevesaga.init.SteveModModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class DarknessWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)SteveModModFluidTypes.DARKNESS_WATER_TYPE.get(), () -> (Fluid)SteveModModFluids.DARKNESS_WATER.get(), () -> (Fluid)SteveModModFluids.FLOWING_DARKNESS_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)SteveModModItems.DARKNESS_WATER_BUCKET.get()).block(() -> (LiquidBlock)SteveModModBlocks.DARKNESS_WATER.get());

    private DarknessWaterFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends DarknessWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends DarknessWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

