/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.mebahel.zombiehorde.util.HordeMemberModConfig;

public class HordeExampleConfigGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void generate(File configDir) {
        File exampleFile = new File(configDir, "horde_example.json");
        if (exampleFile.exists()) {
            System.out.println("[Mebahel's Zombie Horde] 'horde_example.json' already exists, skipping generation.");
            return;
        }
        List<HordeMemberModConfig.HordeComposition> exampleHordes = List.of(new HordeMemberModConfig.HordeComposition(1, List.of("minecraft:overworld"), List.of(new HordeMemberModConfig.HordeMobType("minecraft:zombie", 40, 0.8f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:iron_sword", 0.5f), new HordeMemberModConfig.WeaponConfig("minecraft:stone_sword", 0.3f), new HordeMemberModConfig.WeaponConfig("minecraft:wooden_sword", 0.2f))), new HordeMemberModConfig.HordeMobType("minecraft:skeleton", 30, 1.0f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:bow", 0.3f), new HordeMemberModConfig.WeaponConfig("minecraft:iron_axe", 0.2f), new HordeMemberModConfig.WeaponConfig("minecraft:stone_axe", 0.2f))))), new HordeMemberModConfig.HordeComposition(1, List.of("minecraft:the_nether"), List.of(new HordeMemberModConfig.HordeMobType("minecraft:pillager", 35, 1.0f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:crossbow", 1.0f))), new HordeMemberModConfig.HordeMobType("minecraft:vindicator", 25, 1.0f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:iron_axe", 1.0f))), new HordeMemberModConfig.HordeMobType("minecraft:evoker", 15, 0.0f, List.of()), new HordeMemberModConfig.HordeMobType("minecraft:ravager", 5, 0.0f, List.of()))), new HordeMemberModConfig.HordeComposition(2, List.of("minecraft:the_end"), List.of(new HordeMemberModConfig.HordeMobType("minecraft:wither_skeleton", 40, 0.7f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:stone_sword", 0.4f), new HordeMemberModConfig.WeaponConfig("minecraft:iron_axe", 0.3f))), new HordeMemberModConfig.HordeMobType("minecraft:stray", 20, 0.5f, List.of(new HordeMemberModConfig.WeaponConfig("minecraft:bow", 1.0f))), new HordeMemberModConfig.HordeMobType("minecraft:blaze", 15, 0.0f, List.of()))));
        try (FileWriter writer = new FileWriter(exampleFile);){
            GSON.toJson((Object)new ConfigData(exampleHordes), (Appendable)writer);
            System.out.println("[Mebahel's Zombie Horde] 'horde_example.json' successfully created.");
        }
        catch (IOException e) {
            System.err.println("[Mebahel's Zombie Horde] Failed to create 'horde_example.json': " + e.getMessage());
        }
    }

    private static class ConfigData {
        List<HordeMemberModConfig.HordeComposition> hordeCompositions;

        ConfigData(List<HordeMemberModConfig.HordeComposition> hordeCompositions) {
            this.hordeCompositions = hordeCompositions;
        }
    }
}

